/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.util;

import java.util.ArrayList;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;

public class MultiServerTestBase
extends ActiveMQTestBase {
    protected ActiveMQServer[] servers;
    protected ActiveMQServer[] backupServers;
    protected NodeManager[] nodeManagers;

    protected int getNumberOfServers() {
        return 5;
    }

    protected boolean useBackups() {
        return true;
    }

    protected boolean useRealFiles() {
        return true;
    }

    protected boolean useNetty() {
        return false;
    }

    protected boolean useSharedStorage() {
        return true;
    }

    protected final ServerLocator createLocator(boolean ha, int serverID) {
        TransportConfiguration targetConfig = MultiServerTestBase.createTransportConfiguration((boolean)this.useNetty(), (boolean)false, (Map)MultiServerTestBase.generateParams((int)serverID, (boolean)this.useNetty()));
        if (ha) {
            ServerLocator locator = ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{targetConfig});
            return this.addServerLocator(locator);
        }
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{targetConfig});
        return this.addServerLocator(locator);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.servers = new ActiveMQServer[this.getNumberOfServers()];
        if (this.useBackups()) {
            this.backupServers = new ActiveMQServer[this.getNumberOfServers()];
        }
        if (this.useBackups()) {
            this.nodeManagers = new NodeManager[this.getNumberOfServers()];
        }
        for (int i = 0; i < this.getNumberOfServers(); ++i) {
            Pair<ActiveMQServer, NodeManager> nodeServer = this.setupLiveServer(i, this.useRealFiles(), this.useSharedStorage());
            this.servers[i] = (ActiveMQServer)nodeServer.getA();
            if (!this.useBackups()) continue;
            this.nodeManagers[i] = (NodeManager)nodeServer.getB();
            this.backupServers[i] = this.setupBackupServer(i + this.getNumberOfServers(), i, (NodeManager)nodeServer.getB());
        }
    }

    protected void startServers() throws Exception {
        for (ActiveMQServer server : this.servers) {
            server.start();
        }
        for (ActiveMQServer server : this.servers) {
            this.waitForServerToStart(server);
        }
        if (this.backupServers != null) {
            for (ActiveMQServer server : this.backupServers) {
                server.start();
            }
            for (ActiveMQServer server : this.backupServers) {
                this.waitForServerToStart(server);
            }
        }
        for (ActiveMQServer server : this.servers) {
            MultiServerTestBase.waitForTopology((ActiveMQServer)server, (int)this.getNumberOfServers(), (int)(this.useBackups() ? this.getNumberOfServers() : 0));
        }
    }

    public void startServers(int ... serverID) throws Exception {
        for (int s : serverID) {
            this.servers[s].start();
            this.waitForServerToStart(this.servers[s]);
        }
    }

    public void startBackups(int ... serverID) throws Exception {
        for (int s : serverID) {
            this.backupServers[s].start();
            this.waitForServerToStart(this.backupServers[s]);
        }
    }

    protected Pair<ActiveMQServer, NodeManager> setupLiveServer(int node, boolean realFiles, boolean sharedStorage) throws Exception {
        InVMNodeManager nodeManager = null;
        TransportConfiguration serverConfigAcceptor = MultiServerTestBase.createTransportConfiguration((boolean)this.useNetty(), (boolean)true, (Map)MultiServerTestBase.generateParams((int)node, (boolean)this.useNetty()));
        TransportConfiguration thisConnector = MultiServerTestBase.createTransportConfiguration((boolean)this.useNetty(), (boolean)false, (Map)MultiServerTestBase.generateParams((int)node, (boolean)this.useNetty()));
        if (sharedStorage) {
            nodeManager = new InVMNodeManager(false);
        }
        ConfigurationImpl configuration = this.createBasicConfig(node).setJournalMaxIO_AIO(1000).setThreadPoolMaxSize(10).clearAcceptorConfigurations().addAcceptorConfiguration(serverConfigAcceptor).addConnectorConfiguration("thisConnector", thisConnector).setHAPolicyConfiguration((HAPolicyConfiguration)(sharedStorage ? new SharedStoreMasterPolicyConfiguration() : new ReplicatedPolicyConfiguration()));
        ArrayList<String> targetServersOnConnection = new ArrayList<String>();
        for (int targetNode = 0; targetNode < this.getNumberOfServers(); ++targetNode) {
            if (targetNode == node) continue;
            String targetConnectorName = "target-" + targetNode;
            TransportConfiguration targetServer = MultiServerTestBase.createTransportConfiguration((boolean)this.useNetty(), (boolean)false, (Map)MultiServerTestBase.generateParams((int)targetNode, (boolean)this.useNetty()));
            configuration.getConnectorConfigurations().put(targetConnectorName, targetServer);
            targetServersOnConnection.add(targetConnectorName);
            String backupConnectorName = "backup-" + targetNode;
            TransportConfiguration backupConnector = MultiServerTestBase.createTransportConfiguration((boolean)this.useNetty(), (boolean)false, (Map)MultiServerTestBase.generateParams((int)(targetNode + this.getNumberOfServers()), (boolean)this.useNetty()));
            configuration.getConnectorConfigurations().put(backupConnectorName, backupConnector);
        }
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName("localCluster" + node).setAddress("cluster-queues").setConnectorName("thisConnector").setRetryInterval(100L).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(targetServersOnConnection);
        configuration.getClusterConfigurations().add(clusterConf);
        ActiveMQServer server = sharedStorage ? this.createInVMFailoverServer(realFiles, (Configuration)configuration, (NodeManager)nodeManager, node) : this.createServer(realFiles, (Configuration)configuration);
        server.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/Live(" + node + ")");
        this.addServer(server);
        return new Pair((Object)server, (Object)nodeManager);
    }

    protected ActiveMQServer setupBackupServer(int node, int liveNode, NodeManager nodeManager) throws Exception {
        TransportConfiguration serverConfigAcceptor = MultiServerTestBase.createTransportConfiguration((boolean)this.useNetty(), (boolean)true, (Map)MultiServerTestBase.generateParams((int)node, (boolean)this.useNetty()));
        TransportConfiguration thisConnector = MultiServerTestBase.createTransportConfiguration((boolean)this.useNetty(), (boolean)false, (Map)MultiServerTestBase.generateParams((int)node, (boolean)this.useNetty()));
        ConfigurationImpl configuration = this.createBasicConfig(this.useSharedStorage() ? liveNode : node).clearAcceptorConfigurations().addAcceptorConfiguration(serverConfigAcceptor).addConnectorConfiguration("thisConnector", thisConnector).setHAPolicyConfiguration((HAPolicyConfiguration)(this.useSharedStorage() ? new SharedStoreSlavePolicyConfiguration() : new ReplicaPolicyConfiguration()));
        ArrayList<String> targetServersOnConnection = new ArrayList<String>();
        for (int targetNode = 0; targetNode < this.getNumberOfServers(); ++targetNode) {
            String targetConnectorName = "targetConnector-" + targetNode;
            TransportConfiguration targetServer = MultiServerTestBase.createTransportConfiguration((boolean)this.useNetty(), (boolean)false, (Map)MultiServerTestBase.generateParams((int)targetNode, (boolean)this.useNetty()));
            configuration.addConnectorConfiguration(targetConnectorName, targetServer);
            targetServersOnConnection.add(targetConnectorName);
        }
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName("localCluster" + node).setAddress("cluster-queues").setConnectorName("thisConnector").setRetryInterval(100L).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(targetServersOnConnection);
        configuration.getClusterConfigurations().add(clusterConf);
        ActiveMQServer server = this.useSharedStorage() ? this.createInVMFailoverServer(true, (Configuration)configuration, nodeManager, liveNode) : this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)this.useRealFiles()));
        server.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/Backup(" + node + " of live " + liveNode + ")");
        return server;
    }
}

