/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OpenwireAmqpResenderTest
extends ActiveMQTestBase {
    private static final String OPENWIRE_URL = "tcp://localhost:61616";
    private static final String AMQP_URL = "amqp://localhost:61616";
    private static final String QUEUE_ZERO_NAME = "queue.zero";
    private static final String QUEUE_ONE_NAME = "queue.one";
    private ActiveMQServer server;
    private ActiveMQConnectionFactory factory;
    private JmsConnectionFactory qpidFactory;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        this.factory = new ActiveMQConnectionFactory(OPENWIRE_URL);
        this.qpidFactory = new JmsConnectionFactory(AMQP_URL);
        Configuration serverConfig = this.server.getConfiguration();
        serverConfig.getAddressesSettings().put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setDeadLetterAddress(new SimpleString("ActiveMQ.DLQ")));
        serverConfig.setSecurityEnabled(false);
        this.server.start();
        this.server.createQueue(new QueueConfiguration(QUEUE_ZERO_NAME).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        this.server.createQueue(new QueueConfiguration(QUEUE_ONE_NAME).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    @Test(timeout=5000L)
    public void internalOpenwireBinaryPropShouldBeConvertedAsByteArrays() throws Exception {
        this.openwireSender((ConnectionFactory)this.factory);
        this.amqpResender((ConnectionFactory)this.qpidFactory);
        this.openwireReceiver((ConnectionFactory)this.factory);
    }

    private void openwireSender(ConnectionFactory cf) throws Exception {
        Connection connection = this.factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queueZero = session.createQueue(QUEUE_ZERO_NAME);
        MessageProducer producer = session.createProducer((Destination)queueZero);
        TextMessage testMessage = session.createTextMessage("test");
        producer.send((Message)testMessage);
        connection.close();
    }

    private void amqpResender(ConnectionFactory cf) throws Exception {
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queueZero = session.createQueue(QUEUE_ZERO_NAME);
        Queue queueOne = session.createQueue(QUEUE_ONE_NAME);
        MessageConsumer consumer = session.createConsumer((Destination)queueZero);
        connection.start();
        Message message = consumer.receive();
        OpenwireAmqpResenderTest.assertNotNull((Object)message);
        MessageProducer producer = session.createProducer((Destination)queueOne);
        producer.send(message);
        connection.close();
    }

    private void openwireReceiver(ConnectionFactory cf) throws Exception {
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queueOne = session.createQueue(QUEUE_ONE_NAME);
        MessageConsumer consumer = session.createConsumer((Destination)queueOne);
        connection.start();
        Message receivedMessage = consumer.receive();
        OpenwireAmqpResenderTest.assertNotNull((Object)receivedMessage);
        connection.close();
    }
}

