/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RequestReplyMultiProtocolTest
extends OpenWireTestBase {
    String protocolSender;
    String protocolConsumer;
    ConnectionFactory senderCF;
    ConnectionFactory consumerCF;
    private static final SimpleString queueName = SimpleString.toSimpleString((String)"RequestReplyQueueTest");
    private static final SimpleString topicName = SimpleString.toSimpleString((String)"RequestReplyTopicTest");
    private static final SimpleString replyQueue = SimpleString.toSimpleString((String)"ReplyOnRequestReplyQueueTest");

    public RequestReplyMultiProtocolTest(String protocolSender, String protocolConsumer) {
        this.protocolSender = protocolSender;
        this.protocolConsumer = protocolConsumer;
    }

    @Parameterized.Parameters(name="senderProtocol={0},receiverProtocol={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"OPENWIRE", "OPENWIRE"}, {"OPENWIRE", "CORE"}, {"OPENWIRE", "AMQP"}, {"CORE", "OPENWIRE"}, {"CORE", "CORE"}, {"CORE", "AMQP"}, {"AMQP", "OPENWIRE"}, {"AMQP", "CORE"}, {"AMQP", "AMQP"});
    }

    @Before
    public void setupCF() {
        this.senderCF = CFUtil.createConnectionFactory(this.protocolSender, "tcp://localhost:61616?wireFormat.cacheEnabled=true");
        this.consumerCF = CFUtil.createConnectionFactory(this.protocolConsumer, "tcp://localhost:61616?wireFormat.cacheEnabled=true");
    }

    @Before
    public void setupQueue() throws Exception {
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isStarted());
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(replyQueue).setRoutingType(RoutingType.ANYCAST));
        AddressInfo info = new AddressInfo(topicName, RoutingType.MULTICAST);
        this.server.addAddressInfo(info);
    }

    @Test
    public void testReplyToUsingQueue() throws Throwable {
        this.testReplyTo(false);
    }

    @Test
    public void testReplyToUsingTopic() throws Throwable {
        this.testReplyTo(true);
    }

    private void testReplyTo(boolean useTopic) throws Throwable {
        Connection senderConn = this.senderCF.createConnection();
        Connection consumerConn = this.consumerCF.createConnection();
        consumerConn.setClientID("consumer");
        try {
            Session consumerSess = consumerConn.createSession(false, 1);
            Object consumerDestination = useTopic ? consumerSess.createTopic(topicName.toString()) : consumerSess.createQueue(queueName.toString());
            Object consumer = useTopic ? consumerSess.createDurableSubscriber(consumerDestination, "test") : consumerSess.createConsumer((Destination)consumerDestination);
            consumerConn.start();
            Session senderSess = senderConn.createSession(false, 1);
            LinkedList<Object> replyToDestinations = new LinkedList<Object>();
            replyToDestinations.add(senderSess.createQueue(replyQueue.toString()));
            replyToDestinations.add(senderSess.createTopic(topicName.toString()));
            replyToDestinations.add(senderSess.createTemporaryQueue());
            replyToDestinations.add(senderSess.createTemporaryTopic());
            Object senderDestination = useTopic ? senderSess.createTopic(topicName.toString()) : senderSess.createQueue(queueName.toString());
            MessageProducer sender = senderSess.createProducer((Destination)senderDestination);
            int i = 0;
            for (Destination destination : replyToDestinations) {
                TextMessage message = senderSess.createTextMessage("hello " + i++);
                message.setJMSReplyTo(destination);
                sender.send((Message)message);
            }
            i = 0;
            for (Destination destination : replyToDestinations) {
                TextMessage received = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)received);
                this.instanceLog.debug((Object)("Destination::" + received.getJMSDestination()));
                if (useTopic) {
                    Assert.assertTrue((String)("JMSDestination type is " + received.getJMSDestination().getClass()), (boolean)(received.getJMSDestination() instanceof Topic));
                } else {
                    Assert.assertTrue((String)("JMSDestination type is " + received.getJMSDestination().getClass()), (boolean)(received.getJMSDestination() instanceof Queue));
                }
                Assert.assertNotNull((Object)received.getJMSReplyTo());
                Assert.assertEquals((Object)("hello " + i++), (Object)received.getText());
                this.instanceLog.debug((Object)("received " + received.getText() + " and " + received.getJMSReplyTo()));
                if (destination instanceof Queue) {
                    Assert.assertTrue((String)("Type is " + received.getJMSReplyTo().getClass().toString()), (boolean)(received.getJMSReplyTo() instanceof Queue));
                    Assert.assertEquals((Object)((Queue)destination).getQueueName(), (Object)((Queue)received.getJMSReplyTo()).getQueueName());
                }
                if (destination instanceof Topic) {
                    Assert.assertTrue((String)("Type is " + received.getJMSReplyTo().getClass().toString()), (boolean)(received.getJMSReplyTo() instanceof Topic));
                    Assert.assertEquals((Object)((Topic)destination).getTopicName(), (Object)((Topic)received.getJMSReplyTo()).getTopicName());
                }
                if (destination instanceof TemporaryQueue) {
                    Assert.assertTrue((String)("Type is " + received.getJMSReplyTo().getClass().toString()), (boolean)(received.getJMSReplyTo() instanceof TemporaryQueue));
                    Assert.assertEquals((Object)((TemporaryQueue)destination).getQueueName(), (Object)((TemporaryQueue)received.getJMSReplyTo()).getQueueName());
                }
                if (!(destination instanceof TemporaryTopic)) continue;
                Assert.assertTrue((String)("Type is " + received.getJMSReplyTo().getClass().toString()), (boolean)(received.getJMSReplyTo() instanceof TemporaryTopic));
                Assert.assertEquals((Object)((TemporaryTopic)destination).getTopicName(), (Object)((TemporaryTopic)received.getJMSReplyTo()).getTopicName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                senderConn.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

