/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import java.net.URI;
import java.util.Arrays;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RequestReplyNonJMSTest
extends OpenWireTestBase {
    private static final SimpleString queueName = SimpleString.toSimpleString((String)"RequestReplyQueueTest");
    private static final SimpleString topicName = SimpleString.toSimpleString((String)"RequestReplyTopicTest");
    private static final SimpleString replyQueue = SimpleString.toSimpleString((String)"ReplyOnRequestReplyQueueTest");
    private final String protocolConsumer;
    private ConnectionFactory consumerCF;

    public RequestReplyNonJMSTest(String protocolConsumer) {
        this.protocolConsumer = protocolConsumer;
    }

    @Parameterized.Parameters(name="openWireOnSender={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"OPENWIRE"}, {"CORE"}, {"AMQP"});
    }

    @Before
    public void setupCF() {
        this.consumerCF = CFUtil.createConnectionFactory(this.protocolConsumer, "tcp://localhost:61616?wireFormat.cacheEnabled=true");
    }

    @Before
    public void setupQueue() throws Exception {
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isStarted());
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(replyQueue).setRoutingType(RoutingType.ANYCAST));
        AddressInfo info = new AddressInfo(topicName, RoutingType.MULTICAST);
        this.server.addAddressInfo(info);
    }

    @Test
    public void testReplyToFromAMQPClientWithInvalidTypeAnnotation() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message = new AmqpMessage();
            message.setReplyToAddress(replyQueue.toString());
            message.setMessageAnnotation("x-opt-jms-reply-to", (Object)10);
            message.setMessageId("msg-1");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Queue replyQueue = consumerSess.createQueue(RequestReplyNonJMSTest.replyQueue.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertEquals((Object)replyQueue, (Object)receivedMessage.getJMSReplyTo());
            Assert.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Queue));
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @Test
    public void testReplyToFromAMQPClientWithNoTypeOrOtherAnnotations() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyQueue.toString());
            message.setMessageId("msg-1");
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Queue replyQueue = consumerSess.createQueue(RequestReplyNonJMSTest.replyQueue.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertEquals((Object)replyQueue, (Object)receivedMessage.getJMSReplyTo());
            Assert.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Queue));
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @Test
    public void testReplyToFromAMQPClientWithNoTypeButWithOtherAnnotations() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyQueue.toString());
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-not-jms-reply-to", (Object)1);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Queue replyQueue = consumerSess.createQueue(RequestReplyNonJMSTest.replyQueue.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertEquals((Object)replyQueue, (Object)receivedMessage.getJMSReplyTo());
            Assert.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Queue));
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @Test
    public void testReplyToFromAMQPClientWithQueueReplyToAddress() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyQueue.toString());
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-jms-reply-to", (Object)0);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Queue replyQueue = consumerSess.createQueue(RequestReplyNonJMSTest.replyQueue.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertEquals((Object)replyQueue, (Object)receivedMessage.getJMSReplyTo());
            Assert.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Queue));
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @Test
    public void testReplyToFromAMQPClientWithTopicReplyToAddress() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(topicName.toString());
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-jms-reply-to", (Object)1);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Topic replyTopic = consumerSess.createTopic(topicName.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertEquals((Object)replyTopic, (Object)receivedMessage.getJMSReplyTo());
            Assert.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Topic));
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @Test
    public void testReplyToFromAMQPClientWithTempTopicReplyToAddress() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            String replyToName = UUID.randomUUID().toString();
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyToName);
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-jms-reply-to", (Object)3);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof TemporaryTopic));
            Assert.assertEquals((Object)replyToName, (Object)((TemporaryTopic)receivedMessage.getJMSReplyTo()).getTopicName());
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @Test
    public void testReplyToFromAMQPClientWithTempQueueReplyToAddress() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            String replyToName = UUID.randomUUID().toString();
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyToName);
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-jms-reply-to", (Object)2);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof TemporaryQueue));
            Assert.assertEquals((Object)replyToName, (Object)((TemporaryQueue)receivedMessage.getJMSReplyTo()).getQueueName());
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }
}

