/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.connection;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Test;

public class InvalidConnectorTest
extends JMSTestBase {
    @Test
    public void testInvalidConnector() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("host", "0.0.0.0");
        ArrayList<TransportConfiguration> connectorConfigs = new ArrayList<TransportConfiguration>();
        connectorConfigs.add(new TransportConfiguration(NETTY_CONNECTOR_FACTORY, params));
        int retryInterval = 1000;
        double retryIntervalMultiplier = 1.0;
        int reconnectAttempts = -1;
        int callTimeout = 30000;
        this.jmsServer.createConnectionFactory("invalid-cf", false, JMSFactoryType.CF, (List)this.registerConnectors(this.server, connectorConfigs), null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, (long)callTimeout, 30000L, false, 102400, false, 0x100000, -1, -1, 65536, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, true, 5, -1, (long)retryInterval, retryIntervalMultiplier, ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL, reconnectAttempts, false, null, new String[]{"/invalid-cf"});
        ActiveMQConnectionFactory invalidCf = (ActiveMQConnectionFactory)this.namingContext.lookup("/invalid-cf");
        TransportConfiguration[] tcs = invalidCf.getServerLocator().getStaticTransportConfigurations();
        TransportConfiguration tc = tcs[0];
        InvalidConnectorTest.assertNotSame(tc.getParams().get("host"), (Object)"0.0.0.0");
        InvalidConnectorTest.assertEquals(tc.getParams().get("host"), (Object)InetAddress.getLocalHost().getHostName());
    }
}

