/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.divert;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.List;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Assert;
import org.junit.Test;

public class DivertAndACKClientTest
extends JMSTestBase {
    @Test
    public void testAutoACK() throws Exception {
        Queue queueSource = this.createQueue("Source");
        Queue queueTarget = this.createQueue("Dest");
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)queueSource);
        TextMessage message = session.createTextMessage("message text");
        producer.send((Message)message);
        connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)queueTarget);
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)receivedMessage);
        connection.close();
    }

    @Test
    public void testClientACK() throws Exception {
        Queue queueSource = this.createQueue("Source");
        Queue queueTarget = this.createQueue("Dest");
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)queueSource);
        TextMessage message = session.createTextMessage("message text");
        producer.send((Message)message);
        connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)queueTarget);
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)receivedMessage);
        receivedMessage.acknowledge();
        connection.close();
    }

    @Override
    protected boolean usePersistence() {
        return true;
    }

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        DivertConfiguration divert = new DivertConfiguration().setName("local-divert").setRoutingName("some-name").setAddress("Source").setForwardingAddress("Dest").setExclusive(true);
        Configuration config = super.createDefaultConfig(netty).addDivertConfiguration(divert);
        return config;
    }

    @Override
    protected void createCF(List<TransportConfiguration> connectorConfigs, String ... jndiBindings) throws Exception {
        int retryInterval = 1000;
        double retryIntervalMultiplier = 1.0;
        int reconnectAttempts = -1;
        int callTimeout = 30000;
        this.jmsServer.createConnectionFactory("ManualReconnectionToSingleServerTest", false, JMSFactoryType.CF, (List)this.registerConnectors(this.server, connectorConfigs), null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, (long)callTimeout, 30000L, false, 102400, false, 0x100000, -1, -1, 65536, -1, true, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, true, 5, -1, (long)retryInterval, retryIntervalMultiplier, ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL, reconnectAttempts, false, null, jndiBindings);
    }
}

