/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.LinkedList;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.jgroups.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MqttWildCardSubAutoCreateTest
extends MQTTTestSupport {
    private int lastId;
    private MqttClient subscriber;
    private MqttClient sender;
    private volatile LinkedList<String> topics = new LinkedList();

    @After
    public void clean() throws MqttException {
        this.topics.clear();
        if (this.subscriber != null && this.subscriber.isConnected()) {
            this.subscriber.disconnect();
            this.subscriber.close();
        }
        if (this.sender != null && this.sender.isConnected()) {
            this.sender.disconnect();
            this.sender.close();
        }
    }

    protected ActiveMQServer createServer(boolean realFiles, Configuration configuration) {
        configuration.setGlobalMaxSize(15L);
        return this.createServer(realFiles, configuration, 0xA00000, 10L);
    }

    @Test
    public void testWildcardSubAutoCreateDoesNotPageToWildcardAddress() throws Exception {
        this.server.getManagementService().enableNotifications(false);
        String subscriberId = UUID.randomUUID().toString();
        String senderId = UUID.randomUUID().toString();
        String subscribeTo = "A.*";
        String publishTo = "A.a";
        this.subscriber = this.createMqttClient(subscriberId);
        this.subscriber.subscribe(subscribeTo, 2);
        this.subscriber.disconnect();
        this.sender = this.createMqttClient(senderId);
        this.sender.publish(publishTo, UUID.randomUUID().toString().getBytes(), 2, false);
        this.sender.publish(publishTo, UUID.randomUUID().toString().getBytes(), 2, false);
        MqttWildCardSubAutoCreateTest.assertTrue((boolean)this.server.getPagingManager().getPageStore(new SimpleString(subscribeTo)).isPaging());
        this.subscriber = this.createMqttClient(subscriberId);
        this.subscriber.subscribe(subscribeTo, 2);
        boolean satisfied = Wait.waitFor(() -> this.topics.size() == 2, (long)5000L);
        if (!satisfied) {
            Assert.fail();
        }
        this.subscriber.messageArrivedComplete(this.lastId, 2);
        this.subscriber.disconnect();
        this.subscriber.close();
        for (String topic : this.topics) {
            MqttWildCardSubAutoCreateTest.assertEquals((Object)"A/a", (Object)topic);
        }
    }

    private MqttClient createMqttClient(String clientId) throws MqttException {
        MqttClient client = new MqttClient("tcp://localhost:" + this.getPort(), clientId, (MqttClientPersistence)new MemoryPersistence());
        client.setCallback(this.createCallback());
        client.setManualAcks(true);
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        client.connect(options);
        return client;
    }

    private MqttCallback createCallback() {
        return new MqttCallback(){

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                MqttWildCardSubAutoCreateTest.this.topics.add(topic);
                MqttWildCardSubAutoCreateTest.this.lastId = message.getId();
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            public void connectionLost(Throwable cause) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoreHierarchicalTopic() throws Exception {
        try {
            AssertionLoggerHandler.startCapture();
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
            Connection connection = cf.createConnection();
            connection.setClientID("CLI-ID");
            Session session = connection.createSession(false, 1);
            Topic topicSubscribe = ActiveMQJMSClient.createTopic((String)"news.europe.#");
            MessageConsumer messageConsumer = session.createDurableConsumer(topicSubscribe, "news-eu");
            MessageProducer producer = session.createProducer(null);
            Topic topicNewsUsaWrestling = ActiveMQJMSClient.createTopic((String)"news.usa.wrestling");
            Topic topicNewsEuropeSport = ActiveMQJMSClient.createTopic((String)"news.europe.sport");
            Topic topicNewsEuropeEntertainment = ActiveMQJMSClient.createTopic((String)"news.europe.entertainment");
            TextMessage messageWrestlingNews = session.createTextMessage("Hulk Hogan starts ballet classes");
            this.addSizeProp(messageWrestlingNews);
            producer.send((Destination)topicNewsUsaWrestling, (Message)messageWrestlingNews);
            TextMessage messageEuropeSport = session.createTextMessage("Lewis Hamilton joins European synchronized swimming team");
            producer.send((Destination)topicNewsEuropeSport, (Message)messageEuropeSport);
            TextMessage messageEuropeEntertainment = session.createTextMessage("John Lennon resurrected from dead");
            producer.send((Destination)topicNewsEuropeEntertainment, (Message)messageEuropeEntertainment);
            connection.start();
            Topic topicSubscribeAllNews = ActiveMQJMSClient.createTopic((String)"news.#");
            MessageConsumer messageConsumerAllNews = session.createDurableConsumer(topicSubscribeAllNews, "news-all");
            producer.send((Destination)topicNewsUsaWrestling, (Message)messageWrestlingNews);
            producer.send((Destination)topicNewsEuropeEntertainment, (Message)messageEuropeEntertainment);
            MessageConsumer messageConsumerEuEnt = session.createDurableConsumer(topicNewsEuropeEntertainment, "news-eu-ent");
            producer.send((Destination)topicNewsUsaWrestling, (Message)messageWrestlingNews);
            producer.send((Destination)topicNewsEuropeEntertainment, (Message)messageEuropeEntertainment);
            System.out.println("Usage " + this.server.getPagingManager().getGlobalSize());
            TextMessage msg = (TextMessage)messageConsumerAllNews.receive(5000L);
            System.out.println("1 All received message: " + msg.getText() + ", dest: " + msg.getJMSDestination());
            msg = (TextMessage)messageConsumerAllNews.receive(5000L);
            System.out.println("2 All received message: " + msg.getText() + ", dest: " + msg.getJMSDestination());
            msg = (TextMessage)messageConsumerEuEnt.receive(5000L);
            System.out.println("3 EuEnt received message: " + msg.getText() + ", dest: " + msg.getJMSDestination());
            TextMessage messageReceived1 = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("4 Received message: " + messageReceived1.getText() + ", dest: " + messageReceived1.getJMSDestination());
            TextMessage messageReceived2 = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("5 Received message: " + messageReceived2.getText() + ", dest: " + messageReceived2.getJMSDestination());
            msg = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("6 Eu received message: " + msg.getText() + ", dest: " + msg.getJMSDestination());
            MqttWildCardSubAutoCreateTest.assertEquals((Object)topicNewsEuropeSport, (Object)messageReceived1.getJMSDestination());
            MqttWildCardSubAutoCreateTest.assertEquals((Object)topicNewsEuropeEntertainment, (Object)messageReceived2.getJMSDestination());
            MqttWildCardSubAutoCreateTest.assertEquals((Object)topicNewsEuropeEntertainment, (Object)msg.getJMSDestination());
            messageConsumer.close();
            messageConsumerAllNews.close();
            int countOfPageStores = this.server.getPagingManager().getStoreNames().length;
            MqttWildCardSubAutoCreateTest.assertEquals((String)"there should be 5", (long)5L, (long)countOfPageStores);
            connection.close();
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"222295"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    private void addSizeProp(TextMessage messageWrestlingNews) throws JMSException {
        messageWrestlingNews.setStringProperty("stuff", new String(new byte[1024]));
    }
}

