/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.junit.Assert;
import org.junit.Test;

public class OpenWireUtilTest {
    @Test
    public void testWildcardConversion() throws Exception {
        String amqTarget = "TEST.ONE.>";
        String coreTarget = OpenWireUtil.OPENWIRE_WILDCARD.convert(amqTarget, new WildcardConfiguration());
        Assert.assertEquals((Object)"TEST.ONE.#", (Object)coreTarget);
        amqTarget = "TEST.*.ONE";
        coreTarget = OpenWireUtil.OPENWIRE_WILDCARD.convert(amqTarget, new WildcardConfiguration());
        Assert.assertEquals((Object)"TEST.*.ONE", (Object)coreTarget);
        amqTarget = "a.*.>.>";
        coreTarget = OpenWireUtil.OPENWIRE_WILDCARD.convert(amqTarget, new WildcardConfiguration());
        Assert.assertEquals((Object)"a.*.#.#", (Object)coreTarget);
    }
}

