/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSConsumer13Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public byte destinationType;

    @Parameterized.Parameters(name="deliveryMode={0} destinationType={1}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, (byte)1}, {1, (byte)2}, {1, (byte)5}, {1, (byte)6}, {2, (byte)1}, {2, (byte)2}, {2, (byte)5}, {2, (byte)6});
    }

    public JMSConsumer13Test(int deliveryMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.destinationType = destinationType;
    }

    @Test
    public void testReceiveMessageWithConsumer() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 1);
        Message m = consumer.receive(1000L);
        JMSConsumer13Test.assertNotNull((Object)m);
        JMSConsumer13Test.assertEquals((Object)"0", (Object)((TextMessage)m).getText());
        JMSConsumer13Test.assertNull((Object)consumer.receiveNoWait());
    }
}

