/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.TransactionRolledBackException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.transaction.Synchronization;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionContextTest
extends BasicOpenWireTest {
    TransactionContext underTest;

    @Before
    public void setup() throws Exception {
        this.connection.start();
        this.underTest = new TransactionContext(this.connection);
    }

    @Test
    public void testSyncBeforeEndCalledOnceOnRollback() throws Exception {
        final AtomicInteger beforeEndCountA = new AtomicInteger(0);
        final AtomicInteger beforeEndCountB = new AtomicInteger(0);
        final AtomicInteger rollbackCountA = new AtomicInteger(0);
        final AtomicInteger rollbackCountB = new AtomicInteger(0);
        this.underTest.addSynchronization(new Synchronization(){

            public void beforeEnd() throws Exception {
                if (beforeEndCountA.getAndIncrement() == 0) {
                    throw new TransactionRolledBackException("force rollback");
                }
            }

            public void afterCommit() throws Exception {
                Assert.fail((String)"expected rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountA.incrementAndGet();
            }
        });
        this.underTest.addSynchronization(new Synchronization(){

            public void beforeEnd() throws Exception {
                beforeEndCountB.getAndIncrement();
            }

            public void afterCommit() throws Exception {
                Assert.fail((String)"expected rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountB.incrementAndGet();
            }
        });
        try {
            this.underTest.commit();
            TransactionContextTest.fail((String)"expected rollback exception");
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            // empty catch block
        }
        TransactionContextTest.assertEquals((String)"beforeEnd A called once", (long)1L, (long)beforeEndCountA.get());
        TransactionContextTest.assertEquals((String)"beforeEnd B called once", (long)1L, (long)beforeEndCountA.get());
        TransactionContextTest.assertEquals((String)"rollbackCount B 0", (long)1L, (long)rollbackCountB.get());
        TransactionContextTest.assertEquals((String)"rollbackCount A B", (long)rollbackCountA.get(), (long)rollbackCountB.get());
    }

    @Test
    public void testSyncIndexCleared() throws Exception {
        final AtomicInteger beforeEndCountA = new AtomicInteger(0);
        final AtomicInteger rollbackCountA = new AtomicInteger(0);
        Synchronization sync = new Synchronization(){

            public void beforeEnd() throws Exception {
                beforeEndCountA.getAndIncrement();
            }

            public void afterCommit() throws Exception {
                Assert.fail((String)"expected rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountA.incrementAndGet();
            }
        };
        this.underTest.begin();
        this.underTest.addSynchronization(sync);
        this.underTest.rollback();
        TransactionContextTest.assertEquals((String)"beforeEnd", (long)1L, (long)beforeEndCountA.get());
        TransactionContextTest.assertEquals((String)"rollback", (long)1L, (long)rollbackCountA.get());
        this.underTest.begin();
        this.underTest.addSynchronization(sync);
        this.underTest.rollback();
        TransactionContextTest.assertEquals((String)"beforeEnd", (long)2L, (long)beforeEndCountA.get());
        TransactionContextTest.assertEquals((String)"rollback", (long)2L, (long)rollbackCountA.get());
    }
}

