/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.List;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.jms.persistence.config.PersistedBindings;
import org.apache.activemq.artemis.jms.persistence.config.PersistedDestination;
import org.apache.activemq.artemis.jms.persistence.config.PersistedType;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class JMSStorageManagerTest
extends StorageManagerTestBase {
    public JMSStorageManagerTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Test
    public void testJNDIPersistence() throws Exception {
        this.createJMSStorage();
        this.jmsJournal.storeDestination(new PersistedDestination(PersistedType.Queue, "jndiPersistQueue", null, true));
        this.jmsJournal.addBindings(PersistedType.Queue, "jndiPersistQueue", new String[]{"jndi-1"});
        List destinations = this.jmsJournal.recoverDestinations();
        List jndiList = this.jmsJournal.recoverPersistedBindings();
        Assert.assertEquals((long)1L, (long)destinations.size());
        Assert.assertEquals((long)1L, (long)jndiList.size());
        this.jmsJournal.deleteDestination(PersistedType.Queue, "jndiPersistQueue");
        destinations = this.jmsJournal.recoverDestinations();
        Assert.assertEquals((long)0L, (long)destinations.size());
        this.jmsJournal.stop();
        this.createJMSStorage();
        destinations = this.jmsJournal.recoverDestinations();
        Assert.assertEquals((long)0L, (long)destinations.size());
        jndiList = this.jmsJournal.recoverPersistedBindings();
        Assert.assertEquals((long)1L, (long)jndiList.size());
        PersistedBindings jndi = (PersistedBindings)jndiList.get(0);
        List jndis = jndi.getBindings();
        Assert.assertEquals((long)1L, (long)jndis.size());
        Assert.assertEquals((Object)"jndi-1", jndis.get(0));
    }
}

