/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import jakarta.jms.Destination;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FQQNStompTest
extends StompTestBase {
    private StompClientConnection conn;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v12.stomp"}, {"tcp+v12.stomp"});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        QueueQueryResult result = this.server.queueQuery(new SimpleString(FQQNStompTest.getQueueName()));
        FQQNStompTest.assertTrue((boolean)result.isExists());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            boolean connected;
            boolean bl = connected = this.conn != null && this.conn.isConnected();
            if (connected) {
                try {
                    this.conn.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.conn.closeTransport();
            super.tearDown();
        }
    }

    @Test
    public void testReceiveFQQN() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        FQQNStompTest.subscribeQueue(this.conn, "sub-01", FQQNStompTest.getQueueName() + "\\c\\c" + FQQNStompTest.getQueueName());
        this.sendJmsMessage("Hello World!");
        ClientStompFrame frame = this.conn.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        this.instanceLog.debug((Object)("frame: " + frame));
        FQQNStompTest.unsubscribe(this.conn, "sub-01");
    }

    @Test
    public void testReceiveFQQN2() throws Exception {
        SimpleString myAddress = SimpleString.toSimpleString((String)"myAddress");
        SimpleString q1Name = SimpleString.toSimpleString((String)"q1");
        SimpleString q2Name = SimpleString.toSimpleString((String)"q2");
        Queue q1 = this.server.createQueue(new QueueConfiguration(q1Name).setAddress(myAddress));
        Queue q2 = this.server.createQueue(new QueueConfiguration(q2Name).setAddress(myAddress));
        this.sendJmsMessage("Hello World!", (Destination)ActiveMQJMSClient.createTopic((String)myAddress.toString()));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q1.getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q2.getMessageCount() == 1L, (long)2000L, (long)100L));
        this.conn.connect(this.defUser, this.defPass);
        FQQNStompTest.subscribeQueue(this.conn, "sub-01", myAddress + "\\c\\c" + q1Name);
        ClientStompFrame frame = this.conn.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q1.getMessageCount() == 0L, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q2.getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.unsubscribe(this.conn, "sub-01");
    }

    @Test
    public void testSendFQQNMulticast() throws Exception {
        SimpleString myAddress = SimpleString.toSimpleString((String)"myAddress");
        SimpleString q1Name = SimpleString.toSimpleString((String)"q1");
        SimpleString q2Name = SimpleString.toSimpleString((String)"q2");
        Queue q1 = this.server.createQueue(new QueueConfiguration(q1Name).setAddress(myAddress));
        Queue q2 = this.server.createQueue(new QueueConfiguration(q2Name).setAddress(myAddress));
        this.conn.connect(this.defUser, this.defPass);
        FQQNStompTest.send(this.conn, myAddress + "\\c\\c" + q1Name, null, "Hello World!");
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q1.getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q2.getMessageCount() == 0L, (long)2000L, (long)100L));
        FQQNStompTest.subscribeQueue(this.conn, "sub-01", myAddress + "\\c\\c" + q1Name);
        ClientStompFrame frame = this.conn.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q1.getMessageCount() == 0L, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q2.getMessageCount() == 0L, (long)2000L, (long)100L));
        FQQNStompTest.unsubscribe(this.conn, "sub-01");
    }

    @Test
    public void testSendFQQNAnycast() throws Exception {
        SimpleString myAddress = SimpleString.toSimpleString((String)"myAddress");
        SimpleString q1Name = SimpleString.toSimpleString((String)"q1");
        SimpleString q2Name = SimpleString.toSimpleString((String)"q2");
        Queue q1 = this.server.createQueue(new QueueConfiguration(q1Name).setAddress(myAddress).setRoutingType(RoutingType.ANYCAST));
        Queue q2 = this.server.createQueue(new QueueConfiguration(q2Name).setAddress(myAddress).setRoutingType(RoutingType.ANYCAST));
        this.conn.connect(this.defUser, this.defPass);
        FQQNStompTest.send(this.conn, myAddress.toString(), null, "Hello World!", false, RoutingType.ANYCAST);
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q1.getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.send(this.conn, myAddress.toString(), null, "Hello World!", false, RoutingType.ANYCAST);
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q2.getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.send(this.conn, myAddress + "\\c\\c" + q1Name, null, "Hello World!", false, RoutingType.ANYCAST);
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q1.getMessageCount() == 2L, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q2.getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.send(this.conn, myAddress + "\\c\\c" + q1Name, null, "Hello World!", false, RoutingType.ANYCAST);
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q1.getMessageCount() == 3L, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q2.getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.subscribeQueue(this.conn, "sub-01", myAddress + "\\c\\c" + q1Name);
        ClientStompFrame frame = this.conn.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        frame = this.conn.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        frame = this.conn.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q1.getMessageCount() == 0L, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> q2.getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.unsubscribe(this.conn, "sub-01");
    }

    @Test
    public void testReceiveFQQNSpecial() throws Exception {
        this.conn.connect(this.defUser, this.defPass);
        FQQNStompTest.subscribeQueue(this.conn, "sub-01", "\\c\\c" + FQQNStompTest.getQueueName());
        this.sendJmsMessage("Hello World!");
        ClientStompFrame frame = this.conn.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        this.instanceLog.debug((Object)("frame: " + frame));
        FQQNStompTest.unsubscribe(this.conn, "sub-01");
        frame = FQQNStompTest.subscribeQueue(this.conn, "sub-01", FQQNStompTest.getQueueName() + "\\c\\c");
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"ERROR", (Object)frame.getCommand());
        this.conn.closeTransport();
        this.conn = StompClientConnectionFactory.createClientConnection(this.uri);
        this.conn.connect(this.defUser, this.defPass);
        frame = FQQNStompTest.subscribeQueue(this.conn, "sub-01", "\\c\\c");
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"ERROR", (Object)frame.getCommand());
    }

    @Test
    public void testAutoCreateOnSendFQQN() throws Exception {
        SimpleString myAddress = SimpleString.toSimpleString((String)"myAddress");
        SimpleString q1Name = SimpleString.toSimpleString((String)"q1");
        this.conn.connect(this.defUser, this.defPass);
        FQQNStompTest.send(this.conn, myAddress + "\\c\\c" + q1Name, null, "Hello World!");
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q1Name) != null, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q1Name).getMessageCount() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.subscribeQueue(this.conn, "sub-01", myAddress + "\\c\\c" + q1Name);
        ClientStompFrame frame = this.conn.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q1Name).getMessageCount() == 0L, (long)2000L, (long)100L));
        FQQNStompTest.unsubscribe(this.conn, "sub-01");
    }

    @Test
    public void testAutoCreateOnSubscribeFQQNAnycast() throws Exception {
        this.internalTestAutoCreateOnSubscribeFQQN(RoutingType.ANYCAST);
    }

    @Test
    public void testAutoCreateOnSubscribeFQQNMulticast() throws Exception {
        this.internalTestAutoCreateOnSubscribeFQQN(RoutingType.MULTICAST);
    }

    @Test
    public void testAutoCreateOnSubscribeFQQNNoRoutingType() throws Exception {
        this.internalTestAutoCreateOnSubscribeFQQN(null);
    }

    private void internalTestAutoCreateOnSubscribeFQQN(RoutingType routingType) throws Exception {
        SimpleString myAddress = SimpleString.toSimpleString((String)"myAddress");
        SimpleString q1Name = SimpleString.toSimpleString((String)"q1");
        SimpleString q2Name = SimpleString.toSimpleString((String)"q2");
        StompClientConnection consumer1Connection = StompClientConnectionFactory.createClientConnection(this.uri);
        consumer1Connection.connect(this.defUser, this.defPass);
        ClientStompFrame frame = consumer1Connection.createFrame("SUBSCRIBE").addHeader("destination", myAddress + "\\c\\c" + q1Name).addHeader("id", "sub-01").addHeader("ack", "auto");
        if (routingType != null) {
            frame.addHeader("subscription-type", routingType.toString());
        }
        consumer1Connection.sendFrame(frame);
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q1Name) != null, (long)2000L, (long)100L));
        StompClientConnection consumer2Connection = StompClientConnectionFactory.createClientConnection(this.uri);
        consumer2Connection.connect(this.defUser, this.defPass);
        frame = consumer2Connection.createFrame("SUBSCRIBE").addHeader("destination", myAddress + "\\c\\c" + q2Name).addHeader("id", "sub-02").addHeader("ack", "auto");
        if (routingType != null) {
            frame.addHeader("subscription-type", routingType.toString());
        }
        consumer2Connection.sendFrame(frame);
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q1Name) != null, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q2Name) != null, (long)2000L, (long)100L));
        StompClientConnection senderConnection = StompClientConnectionFactory.createClientConnection(this.uri);
        senderConnection.connect(this.defUser, this.defPass);
        FQQNStompTest.send(senderConnection, myAddress + "\\c\\c" + q1Name, null, "Hello World!", false, routingType);
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q1Name).getMessagesAdded() == 1L, (long)2000L, (long)100L));
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q2Name).getMessagesAdded() == 0L, (long)2000L, (long)100L));
        frame = consumer1Connection.receiveFrame(2000L);
        FQQNStompTest.assertNotNull((Object)frame);
        FQQNStompTest.assertEquals((Object)"Hello World!", (Object)frame.getBody());
        FQQNStompTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(q1Name).getMessageCount() == 0L, (long)4000L, (long)100L));
        FQQNStompTest.unsubscribe(consumer1Connection, "sub-01");
        FQQNStompTest.unsubscribe(consumer2Connection, "sub-02");
    }
}

