/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.transport.netty.NettyTransport;
import org.apache.activemq.transport.netty.NettyTransportFactory;
import org.apache.activemq.transport.netty.NettyTransportListener;
import org.junit.Test;

public class NettyHandshakeTimeoutTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;
    private Configuration conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandshakeTimeout() throws Exception {
        int handshakeTimeout = 3;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("handshake-timeout", handshakeTimeout);
        this.conf = this.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.conf, (boolean)false));
        this.server.start();
        transport.setTransportListener(new NettyTransportListener(){

            public void onData(ByteBuf incoming) {
            }

            public void onTransportClosed() {
            }

            public void onTransportError(Throwable cause) {
            }
        });
        try (NettyTransport transport = NettyTransportFactory.createTransport((URI)new URI("tcp://127.0.0.1:61616"));){
            transport.connect();
            NettyHandshakeTimeoutTest.assertTrue((String)"Connection should be closed now", (boolean)Wait.waitFor(() -> !transport.isConnected(), (long)TimeUnit.SECONDS.toMillis(handshakeTimeout + 10)));
        }
        this.server.stop();
    }
}

