/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.impl;

import java.io.File;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class FileLockTest
extends ActiveMQTestBase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File file = new File(this.getTestDir());
        file.mkdirs();
    }

    @Test
    public void testSetNodeID() throws Exception {
        FileLockNodeManager underTest = new FileLockNodeManager(this.getTestDirfile(), false);
        ReplicationPrimaryPolicyConfiguration replicationPrimaryPolicyConfiguration = ReplicationPrimaryPolicyConfiguration.withDefault();
        String seed = "";
        for (int i = 0; i < 20; ++i) {
            replicationPrimaryPolicyConfiguration.setCoordinationId(seed);
            if (replicationPrimaryPolicyConfiguration.getCoordinationId() != null) {
                underTest.setNodeID(replicationPrimaryPolicyConfiguration.getCoordinationId());
            }
            seed = seed + String.valueOf(i);
        }
        replicationPrimaryPolicyConfiguration.setCoordinationId("somme-dash-and-odd");
        if (replicationPrimaryPolicyConfiguration.getCoordinationId() != null) {
            underTest.setNodeID(replicationPrimaryPolicyConfiguration.getCoordinationId());
        }
    }

    @Test
    public void testNIOLock() throws Exception {
        this.doTestLock(new FileLockNodeManager(this.getTestDirfile(), false), new FileLockNodeManager(this.getTestDirfile(), false));
    }

    public void doTestLock(FileLockNodeManager lockManager1, final FileLockNodeManager lockManager2) throws Exception {
        lockManager1.start();
        lockManager2.start();
        lockManager1.startLiveNode();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    lockManager2.startLiveNode();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        FileLockTest.assertTrue((boolean)lockManager1.isLiveLocked());
        Thread.sleep(500L);
        FileLockTest.assertFalse((boolean)lockManager2.isLiveLocked());
        lockManager1.crashLiveServer();
        t.join();
        FileLockTest.assertFalse((boolean)lockManager1.isLiveLocked());
        FileLockTest.assertTrue((boolean)lockManager2.isLiveLocked());
        lockManager2.crashLiveServer();
        lockManager1.stop();
        lockManager2.stop();
    }
}

