/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.addressing;

import java.util.HashSet;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class AddressConfigTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultInVMConfig();
        this.server = this.createServer(true, configuration);
        this.server.start();
    }

    @Test
    public void persistAddressConfigTest() throws Exception {
        this.server.createQueue(new QueueConfiguration("myQueue").setAddress("myAddress"));
        this.server.stop();
        this.server.start();
        AddressInfo addressInfo = this.server.getAddressInfo(SimpleString.toSimpleString((String)"myAddress"));
        AddressConfigTest.assertNotNull((Object)addressInfo);
        HashSet<RoutingType> routingTypeSet = new HashSet<RoutingType>();
        routingTypeSet.add(RoutingType.MULTICAST);
        AddressConfigTest.assertEquals(routingTypeSet, (Object)addressInfo.getRoutingTypes());
        AddressConfigTest.assertFalse((boolean)addressInfo.isPaused());
        addressInfo.setPostOffice(this.server.getPostOffice());
        addressInfo.setStorageManager(this.server.getStorageManager());
        addressInfo.pause(true);
        AddressConfigTest.assertTrue((boolean)addressInfo.isPaused());
        long id = addressInfo.getId();
        this.server.stop();
        this.server.start();
        addressInfo = this.server.getAddressInfo(SimpleString.toSimpleString((String)"myAddress"));
        AddressConfigTest.assertNotNull((Object)addressInfo);
        routingTypeSet = new HashSet();
        routingTypeSet.add(RoutingType.MULTICAST);
        AddressConfigTest.assertEquals(routingTypeSet, (Object)addressInfo.getRoutingTypes());
        AddressConfigTest.assertEquals((long)id, (long)addressInfo.getId());
        AddressConfigTest.assertTrue((boolean)addressInfo.isPaused());
        addressInfo.setPostOffice(this.server.getPostOffice());
        addressInfo.setStorageManager(this.server.getStorageManager());
        addressInfo.resume();
    }
}

