/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpFrameValidator;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.Detach;
import org.apache.qpid.proton.engine.Receiver;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpDurableReceiverTest
extends AmqpClientTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpDurableReceiverTest.class);
    private final String SELECTOR_STRING = "color = red";

    @Test(timeout=60000L)
    public void testCreateDurableReceiver() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        receiver.flow(1);
        AmqpDurableReceiverTest.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
        AmqpSender sender = session.createSender(this.getTopicName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("message:1");
        sender.send(message);
        message = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpDurableReceiverTest.assertNotNull((Object)message);
        connection.close();
        AmqpDurableReceiverTest.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
    }

    @Test(timeout=60000L)
    public void testDetachedDurableReceiverRemainsActive() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        connection.setReceivedFrameInspector(new AmqpFrameValidator(){

            public void inspectDetach(Detach detach, Binary encoded) {
                if (detach.getClosed()) {
                    this.markAsInvalid("Remote should have detached but closed instead.");
                }
            }
        });
        connection.setSentFrameInspector(new AmqpFrameValidator(){

            public void inspectDetach(Detach detach, Binary encoded) {
                if (detach.getClosed()) {
                    this.markAsInvalid("Client should have detached but closed instead.");
                }
            }
        });
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        AmqpDurableReceiverTest.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
        receiver.detach();
        AmqpDurableReceiverTest.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
        connection.getSentFrameInspector().assertValid();
        connection.getReceivedFrameInspector().assertValid();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCloseDurableReceiverRemovesSubscription() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        AmqpDurableReceiverTest.assertEquals((Object)this.getTopicName(), (Object)this.lookupSubscription());
        receiver.close();
        AmqpDurableReceiverTest.assertNull((Object)this.lookupSubscription());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReattachToDurableNode() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        receiver.detach();
        receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testLookupExistingSubscription() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName());
        receiver.detach();
        receiver = session.lookupSubscription(this.getSubscriptionName());
        AmqpDurableReceiverTest.assertNotNull((Object)receiver);
        Receiver protonReceiver = receiver.getReceiver();
        AmqpDurableReceiverTest.assertNotNull((Object)protonReceiver.getRemoteSource());
        Source remoteSource = (Source)protonReceiver.getRemoteSource();
        if (remoteSource.getFilter() != null) {
            AmqpDurableReceiverTest.assertFalse((boolean)remoteSource.getFilter().containsKey(AmqpSupport.NO_LOCAL_NAME));
            AmqpDurableReceiverTest.assertFalse((boolean)remoteSource.getFilter().containsKey(AmqpSupport.JMS_SELECTOR_NAME));
        }
        AmqpDurableReceiverTest.assertEquals((Object)TerminusExpiryPolicy.NEVER, (Object)remoteSource.getExpiryPolicy());
        AmqpDurableReceiverTest.assertEquals((Object)TerminusDurability.UNSETTLED_STATE, (Object)remoteSource.getDurable());
        AmqpDurableReceiverTest.assertEquals((Object)AmqpSupport.COPY, (Object)remoteSource.getDistributionMode());
        receiver.close();
        try {
            receiver = session.lookupSubscription(this.getSubscriptionName());
            AmqpDurableReceiverTest.fail((String)"Should not be able to lookup the subscription");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test(timeout=60000L)
    public void testLookupExistingSubscriptionWithSelector() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName(), "color = red", false);
        receiver.detach();
        receiver = session.lookupSubscription(this.getSubscriptionName());
        AmqpDurableReceiverTest.assertNotNull((Object)receiver);
        Receiver protonReceiver = receiver.getReceiver();
        AmqpDurableReceiverTest.assertNotNull((Object)protonReceiver.getRemoteSource());
        Source remoteSource = (Source)protonReceiver.getRemoteSource();
        AmqpDurableReceiverTest.assertNotNull((Object)remoteSource.getFilter());
        AmqpDurableReceiverTest.assertFalse((boolean)remoteSource.getFilter().containsKey(AmqpSupport.NO_LOCAL_NAME));
        AmqpDurableReceiverTest.assertTrue((boolean)remoteSource.getFilter().containsKey(AmqpSupport.JMS_SELECTOR_NAME));
        String selector = (String)((DescribedType)remoteSource.getFilter().get(AmqpSupport.JMS_SELECTOR_NAME)).getDescribed();
        AmqpDurableReceiverTest.assertEquals((Object)"color = red", (Object)selector);
        AmqpDurableReceiverTest.assertEquals((Object)TerminusExpiryPolicy.NEVER, (Object)remoteSource.getExpiryPolicy());
        AmqpDurableReceiverTest.assertEquals((Object)TerminusDurability.UNSETTLED_STATE, (Object)remoteSource.getDurable());
        AmqpDurableReceiverTest.assertEquals((Object)AmqpSupport.COPY, (Object)remoteSource.getDistributionMode());
        receiver.close();
        try {
            receiver = session.lookupSubscription(this.getSubscriptionName());
            AmqpDurableReceiverTest.fail((String)"Should not be able to lookup the subscription");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test(timeout=60000L)
    public void testLookupExistingSubscriptionWithNoLocal() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName(), null, true);
        receiver.detach();
        receiver = session.lookupSubscription(this.getSubscriptionName());
        AmqpDurableReceiverTest.assertNotNull((Object)receiver);
        Receiver protonReceiver = receiver.getReceiver();
        AmqpDurableReceiverTest.assertNotNull((Object)protonReceiver.getRemoteSource());
        Source remoteSource = (Source)protonReceiver.getRemoteSource();
        AmqpDurableReceiverTest.assertNotNull((Object)remoteSource.getFilter());
        AmqpDurableReceiverTest.assertTrue((boolean)remoteSource.getFilter().containsKey(AmqpSupport.NO_LOCAL_NAME));
        AmqpDurableReceiverTest.assertFalse((boolean)remoteSource.getFilter().containsKey(AmqpSupport.JMS_SELECTOR_NAME));
        AmqpDurableReceiverTest.assertEquals((Object)TerminusExpiryPolicy.NEVER, (Object)remoteSource.getExpiryPolicy());
        AmqpDurableReceiverTest.assertEquals((Object)TerminusDurability.UNSETTLED_STATE, (Object)remoteSource.getDurable());
        AmqpDurableReceiverTest.assertEquals((Object)AmqpSupport.COPY, (Object)remoteSource.getDistributionMode());
        receiver.close();
        try {
            receiver = session.lookupSubscription(this.getSubscriptionName());
            AmqpDurableReceiverTest.fail((String)"Should not be able to lookup the subscription");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test(timeout=60000L)
    public void testLookupExistingSubscriptionWithSelectorAndNoLocal() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver(this.getTopicName(), this.getSubscriptionName(), "color = red", true);
        receiver.detach();
        receiver = session.lookupSubscription(this.getSubscriptionName());
        AmqpDurableReceiverTest.assertNotNull((Object)receiver);
        Receiver protonReceiver = receiver.getReceiver();
        AmqpDurableReceiverTest.assertNotNull((Object)protonReceiver.getRemoteSource());
        Source remoteSource = (Source)protonReceiver.getRemoteSource();
        AmqpDurableReceiverTest.assertNotNull((Object)remoteSource.getFilter());
        AmqpDurableReceiverTest.assertTrue((boolean)remoteSource.getFilter().containsKey(AmqpSupport.NO_LOCAL_NAME));
        AmqpDurableReceiverTest.assertTrue((boolean)remoteSource.getFilter().containsKey(AmqpSupport.JMS_SELECTOR_NAME));
        String selector = (String)((DescribedType)remoteSource.getFilter().get(AmqpSupport.JMS_SELECTOR_NAME)).getDescribed();
        AmqpDurableReceiverTest.assertEquals((Object)"color = red", (Object)selector);
        AmqpDurableReceiverTest.assertEquals((Object)TerminusExpiryPolicy.NEVER, (Object)remoteSource.getExpiryPolicy());
        AmqpDurableReceiverTest.assertEquals((Object)TerminusDurability.UNSETTLED_STATE, (Object)remoteSource.getDurable());
        AmqpDurableReceiverTest.assertEquals((Object)AmqpSupport.COPY, (Object)remoteSource.getDistributionMode());
        receiver.close();
        try {
            receiver = session.lookupSubscription(this.getSubscriptionName());
            AmqpDurableReceiverTest.fail((String)"Should not be able to lookup the subscription");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test(timeout=60000L)
    public void testLookupNonExistingSubscription() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        try {
            session.lookupSubscription(this.getSubscriptionName());
            AmqpDurableReceiverTest.fail((String)"Should throw an exception since there is not subscription");
        }
        catch (Exception e) {
            LOG.debug("Error on lookup: {}", (Object)e.getMessage());
        }
        connection.close();
    }

    public String lookupSubscription() {
        Binding binding = this.server.getPostOffice().getBinding(new SimpleString(this.getContainerID() + "." + this.getSubscriptionName()));
        if (binding != null) {
            return binding.getAddress().toString();
        }
        return null;
    }

    private String getContainerID() {
        return "myContainerID";
    }

    private String getSubscriptionName() {
        return "mySubscription";
    }
}

