/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpMessagePriorityTest
extends AmqpClientTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AmqpMessagePriorityTest.class);

    @Test(timeout=60000L)
    public void testMessageDefaultPriority() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("MessageID:1");
        message.setPriority((short)4);
        sender.send(message);
        sender.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((Long)1L, () -> ((Queue)queueView).getMessageCount(), (long)5000L, (long)10L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpMessagePriorityTest.assertNotNull((Object)receive);
        AmqpMessagePriorityTest.assertEquals((long)4L, (long)receive.getPriority());
        receiver.close();
        AmqpMessagePriorityTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessagePriorityPreservedAfterServerRestart() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setDurable(true);
        message.setMessageId("MessageID:1");
        message.setPriority((short)7);
        sender.send(message);
        sender.close();
        connection.close();
        this.server.stop();
        this.server.start();
        client = this.createAmqpClient();
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpMessagePriorityTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpMessagePriorityTest.assertNotNull((Object)receive);
        AmqpMessagePriorityTest.assertEquals((long)7L, (long)receive.getPriority());
        receiver.close();
        AmqpMessagePriorityTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessageNonDefaultPriority() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("MessageID:1");
        message.setPriority((short)0);
        sender.send(message);
        sender.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((Long)1L, () -> ((Queue)queueView).getMessageCount(), (long)5000L, (long)10L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpMessagePriorityTest.assertNotNull((Object)receive);
        AmqpMessagePriorityTest.assertEquals((long)0L, (long)receive.getPriority());
        receiver.close();
        AmqpMessagePriorityTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessageWithVeryHighPriority() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("MessageID:1");
        message.setPriority((short)99);
        sender.send(message);
        sender.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((Long)1L, () -> ((Queue)queueView).getMessageCount(), (long)5000L, (long)10L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpMessagePriorityTest.assertNotNull((Object)receive);
        AmqpMessagePriorityTest.assertEquals((long)99L, (long)receive.getPriority());
        receiver.close();
        AmqpMessagePriorityTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessageNoPriority() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("MessageID:1");
        sender.send(message);
        sender.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((Long)1L, () -> ((Queue)queueView).getMessageCount(), (long)5000L, (long)10L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpMessagePriorityTest.assertNotNull((Object)receive);
        AmqpMessagePriorityTest.assertEquals((long)4L, (long)receive.getPriority());
        receiver.close();
        AmqpMessagePriorityTest.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMessagePriorityOrdering() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (short i = 0; i <= 9; i = (short)(i + 1)) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("MessageID:" + i);
            message.setPriority(i);
            sender.send(message);
        }
        sender.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((Long)10L, () -> ((Queue)queueView).getMessageCount(), (long)5000L, (long)10L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(10);
        for (int i = 9; i >= 0; --i) {
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpMessagePriorityTest.assertNotNull((Object)received);
            AmqpMessagePriorityTest.assertEquals((long)((short)i), (long)received.getPriority());
            received.accept();
        }
        receiver.close();
        Wait.assertEquals((Long)0L, () -> ((Queue)queueView).getMessageCount(), (long)5000L, (long)10L);
        connection.close();
    }
}

