/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URL;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ExecuteUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class QpidDispatchPeerTest
extends AmqpClientTestSupport {
    private static final Logger logger = Logger.getLogger(QpidDispatchPeerTest.class);
    ExecuteUtil.ProcessHolder qpidProcess;

    @BeforeClass
    public static void validateqdrotuer() {
        try {
            int result = ExecuteUtil.runCommand((boolean)true, (String[])new String[]{"qdrouterd", "--version"});
            Assume.assumeTrue((String)"qdrouterd does not exist", (result == 0 ? (byte)1 : 0) != 0);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            Assume.assumeNoException((String)"qdrouterd does not exist", (Throwable)e);
        }
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        ActiveMQServer server = this.createServer(5672, false);
        server.getConfiguration().setNetworkCheckPeriod(100L);
        return server;
    }

    @Before
    public void startQpidRouter() throws Exception {
        URL qpidConfig = ((Object)((Object)this)).getClass().getClassLoader().getResource("QpidRouterPeerTest-qpidr.conf");
        this.qpidProcess = ExecuteUtil.run((boolean)true, (String[])new String[]{"qdrouterd", "-c", qpidConfig.getFile()});
    }

    @After
    public void stopQpidRouter() throws Exception {
        this.qpidProcess.kill();
    }

    public void pauseThenKill(int timeToWait) throws Exception {
        int pid = this.qpidProcess.pid();
        int result = ExecuteUtil.runCommand((boolean)true, (String[])new String[]{"kill", "-STOP", Long.toString(pid)});
        Assert.assertEquals((long)0L, (long)result);
        logger.info((Object)"\n*******************************************************************************************************************************\nPaused\n*******************************************************************************************************************************");
        Thread.sleep(timeToWait);
        result = ExecuteUtil.runCommand((boolean)true, (String[])new String[]{"kill", "-9", Long.toString(pid)});
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test(timeout=60000L)
    public void testWithMatchingDifferentNamesOnQueueKill() throws Exception {
        this.internalMultipleQueues(true, true, true, false, false);
    }

    @Test(timeout=60000L)
    public void testWithMatchingDifferentNamesOnQueueKillMaxAttempts() throws Exception {
        this.internalMultipleQueues(true, true, true, false, true);
    }

    @Test(timeout=60000L)
    public void testWithMatchingDifferentNamesOnQueuePauseMaxAttempts() throws Exception {
        this.internalMultipleQueues(true, true, false, true, false);
    }

    @Test(timeout=60000L)
    public void testWithMatchingDifferentNamesOnQueuePause() throws Exception {
        this.internalMultipleQueues(true, true, false, true, false);
    }

    @Test(timeout=60000L)
    public void testWithMatchingDifferentNamesOnQueue() throws Exception {
        this.internalMultipleQueues(true, true, false, false, false);
    }

    @Test(timeout=60000L)
    public void testWithMatching() throws Exception {
        this.internalMultipleQueues(true, false, false, false, false);
    }

    @Test(timeout=60000L)
    public void testwithQueueName() throws Exception {
        this.internalMultipleQueues(false, false, false, false, false);
    }

    @Test(timeout=60000L)
    public void testwithQueueNameDistinctName() throws Exception {
        this.internalMultipleQueues(false, true, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMultipleQueues(boolean useMatching, boolean distinctNaming, boolean kill, boolean pause, boolean maxReconnectAttemps) throws Exception {
        Queue testQueueOnServer;
        int i;
        int numberOfMessages = 100;
        int numberOfQueues = 10;
        String brokerConnectionName = "brokerConnection." + UUIDGenerator.getInstance().generateStringUUID();
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(brokerConnectionName, "tcp://localhost:24622?amqpIdleTimeout=1000").setRetryInterval(10).setReconnectAttempts(maxReconnectAttemps ? 10 : -1);
        if (useMatching) {
            amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress("queue.#").setType(AMQPBrokerConnectionAddressType.PEER));
        } else {
            for (i = 0; i < 10; ++i) {
                amqpConnection.addElement(new AMQPBrokerConnectionElement().setQueueName(this.createQueueName(i, distinctNaming)).setType(AMQPBrokerConnectionAddressType.PEER));
            }
        }
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        for (i = 0; i < 10; ++i) {
            this.server.addAddressInfo(new AddressInfo("queue.test" + i).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false).setTemporary(false));
            this.server.createQueue(new QueueConfiguration(this.createQueueName(i, distinctNaming)).setAddress("queue.test" + i).setRoutingType(RoutingType.ANYCAST));
        }
        for (int dest = 0; dest < 10; ++dest) {
            ConnectionFactory factoryProducer = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:24622");
            Connection connection = null;
            connection = this.createConnectionDumbRetry(factoryProducer);
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue("queue.test" + dest);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(1);
            testQueueOnServer = this.server.locateQueue(this.createQueueName(dest, distinctNaming));
            for (int i2 = 0; i2 < 100; ++i2) {
                producer.send((Message)session.createTextMessage("hello " + i2));
            }
            Wait.assertEquals((long)100L, () -> ((Queue)testQueueOnServer).getMessageCount());
            connection.close();
        }
        if (kill) {
            this.qpidProcess.kill();
            if (maxReconnectAttemps) {
                Thread.sleep(1000L);
            }
            this.startQpidRouter();
        } else if (pause) {
            this.pauseThenKill(3000);
            this.startQpidRouter();
        }
        if (maxReconnectAttemps) {
            ConnectionFactory factoryConsumer = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:24622");
            Connection connection = this.createConnectionDumbRetry(factoryConsumer);
            connection.close();
            this.server.stopBrokerConnection(brokerConnectionName);
            this.server.startBrokerConnection(brokerConnectionName);
        }
        for (int dest = 0; dest < 10; ++dest) {
            ConnectionFactory factoryConsumer = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:24622");
            Connection connectionConsumer = this.createConnectionDumbRetry(factoryConsumer);
            Session sessionConsumer = connectionConsumer.createSession(false, 1);
            jakarta.jms.Queue queueConsumer = sessionConsumer.createQueue("queue.test" + dest);
            MessageConsumer consumer = sessionConsumer.createConsumer((Destination)queueConsumer);
            connectionConsumer.start();
            try {
                for (int i3 = 0; i3 < 100; ++i3) {
                    TextMessage received = (TextMessage)consumer.receive(5000L);
                    if (received == null) {
                        System.out.println("*******************************************************************************************************************************");
                        System.out.println("qdstat after message timed out:");
                        ExecuteUtil.runCommand((boolean)true, (String[])new String[]{"qdstat", "-b", "127.0.0.1:24622", "-l"});
                        System.out.println("*******************************************************************************************************************************");
                    }
                    Assert.assertNotNull((Object)received);
                    Assert.assertEquals((Object)("hello " + i3), (Object)received.getText());
                }
                Assert.assertNull((Object)consumer.receiveNoWait());
            }
            finally {
                try {
                    connectionConsumer.close();
                }
                catch (Throwable i3) {}
            }
            testQueueOnServer = this.server.locateQueue(this.createQueueName(dest, distinctNaming));
            Wait.assertEquals((long)0L, () -> ((Queue)testQueueOnServer).getMessageCount());
        }
    }

    private String createQueueName(int i, boolean useDistinctName) {
        if (useDistinctName) {
            return "distinct.test" + i;
        }
        return "queue.test" + i;
    }

    private Connection createConnectionDumbRetry(ConnectionFactory factoryProducer) throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            try {
                return factoryProducer.createConnection();
            }
            catch (Exception e) {
                Thread.sleep(10L);
                continue;
            }
        }
        return null;
    }
}

