/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.Assert;
import org.junit.Test;

public class AmqpFilterChangePageTest
extends ActiveMQTestBase {
    ActiveMQServer server;

    @Test
    public void testChangingMatching() throws Exception {
        Configuration config = this.createDefaultConfig(true);
        int NUMBER_OF_MESSAGES = 2000;
        this.server = this.createServer(true, config, 102400, 0x100000L);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo("AD1").addRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(new QueueConfiguration("Q1").setAddress("AD1").setDurable(Boolean.valueOf(true)).setFilterString("color='red'"));
        ConnectionFactory cf = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61616");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)session.createTopic("AD1"));
        Queue queue = this.server.locateQueue("Q1");
        queue.getPagingStore().startPaging();
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session.createTextMessage("hello " + i);
            message.setStringProperty("color", "red");
            producer.send((Message)message);
            if (i % 100 != 0 || i <= 0) continue;
            session.commit();
            queue.getPagingStore().forceAnotherPage();
        }
        session.commit();
        PageSubscriptionImpl subscription = (PageSubscriptionImpl)queue.getPageSubscription();
        Field subscriptionField = PageSubscriptionImpl.class.getDeclaredField("filter");
        subscriptionField.setAccessible(true);
        subscriptionField.set(subscription, new Filter(){

            public boolean match(org.apache.activemq.artemis.api.core.Message message) {
                return false;
            }

            public boolean match(Map<String, String> map) {
                return false;
            }

            public boolean match(Filterable filterable) {
                return false;
            }

            public SimpleString getFilterString() {
                return null;
            }
        });
        connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("AD1::Q1"));
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            Message message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
        }
        session.commit();
        Assert.assertNull((Object)consumer.receiveNoWait());
        connection.close();
    }
}

