/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class JMSPagingFileDeleteTest
extends JMSTestBase {
    Topic topic1;
    Connection connection;
    Session session;
    MessageConsumer subscriber1;
    MessageConsumer subscriber2;
    PagingStore pagingStore;
    private static final int MESSAGE_SIZE = 1024;
    private static final int PAGE_SIZE = 10240;
    private static final int PAGE_MAX = 20480;
    private static final int RECEIVE_TIMEOUT = 500;
    private static final int MESSAGE_NUM = 50;

    @Override
    protected boolean usePersistence() {
        return true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.topic1 = this.createTopic("topic1");
        AddressSettings setting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)setting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopicsWithNonDurableSubscription() throws Exception {
        this.connection = null;
        try {
            for (int repeat = 0; repeat < 2; ++repeat) {
                this.connection = this.cf.createConnection();
                this.connection.setClientID("cid");
                this.session = this.connection.createSession(false, 1);
                MessageProducer producer = this.session.createProducer((Destination)this.topic1);
                this.subscriber1 = this.session.createConsumer((Destination)this.topic1);
                this.instanceLog.debug((Object)"---------- Send messages. ----------");
                BytesMessage bytesMessage = this.session.createBytesMessage();
                bytesMessage.writeBytes(new byte[1024]);
                for (int i = 0; i < 50; ++i) {
                    producer.send((Message)bytesMessage);
                }
                this.instanceLog.debug((Object)"Sent 50 messages.");
                this.pagingStore = this.server.getPagingManager().getPageStore(new SimpleString("topic1"));
                this.printPageStoreInfo(this.pagingStore);
                JMSPagingFileDeleteTest.assertTrue((boolean)this.pagingStore.isPaging());
                this.connection.close();
                Wait.assertFalse(() -> ((PagingStore)this.pagingStore).isPaging());
                this.printPageStoreInfo(this.pagingStore);
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopics() throws Exception {
        this.connection = null;
        try {
            int i;
            this.connection = this.cf.createConnection();
            this.connection.setClientID("cid");
            this.session = this.connection.createSession(false, 1);
            MessageProducer producer = this.session.createProducer((Destination)this.topic1);
            this.subscriber1 = this.session.createDurableSubscriber(this.topic1, "subscriber-1");
            this.subscriber2 = this.session.createDurableSubscriber(this.topic1, "subscriber-2");
            this.instanceLog.debug((Object)"---------- Send messages. ----------");
            BytesMessage bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(new byte[1024]);
            for (i = 0; i < 50; ++i) {
                producer.send((Message)bytesMessage);
            }
            this.instanceLog.debug((Object)"Sent 50 messages.");
            this.pagingStore = this.server.getPagingManager().getPageStore(new SimpleString("topic1"));
            this.printPageStoreInfo(this.pagingStore);
            JMSPagingFileDeleteTest.assertTrue((boolean)this.pagingStore.isPaging());
            this.connection.start();
            this.stopAndStartServer();
            this.instanceLog.debug((Object)"---------- Receive all messages. ----------");
            for (i = 0; i < 50; ++i) {
                Message message1 = this.subscriber1.receive(500L);
                JMSPagingFileDeleteTest.assertNotNull((Object)message1);
                Message message2 = this.subscriber2.receive(500L);
                JMSPagingFileDeleteTest.assertNotNull((Object)message2);
            }
            this.pagingStore = this.server.getPagingManager().getPageStore(new SimpleString("topic1"));
            long timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && this.pagingStore.isPaging()) {
                Thread.sleep(100L);
            }
            JMSPagingFileDeleteTest.assertFalse((boolean)this.pagingStore.isPaging());
            this.printPageStoreInfo(this.pagingStore);
            JMSPagingFileDeleteTest.assertEquals((long)0L, (long)this.pagingStore.getAddressSize());
            JMSPagingFileDeleteTest.assertFalse((boolean)this.pagingStore.isPaging());
            producer = this.session.createProducer((Destination)this.topic1);
            bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(new byte[1024]);
            producer.send((Message)bytesMessage);
            this.printPageStoreInfo(this.pagingStore);
            timeout = System.currentTimeMillis() + 10000L;
            Wait.assertEquals((int)0, () -> ((PagingStore)this.pagingStore).getNumberOfPages());
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    private void stopAndStartServer() throws Exception {
        this.instanceLog.debug((Object)"---------- Restart server. ----------");
        this.connection.close();
        this.jmsServer.stop();
        this.jmsServer.start();
        this.jmsServer.activated();
        this.registerConnectionFactory();
        this.printPageStoreInfo(this.pagingStore);
        this.reconnect();
    }

    private void reconnect() throws Exception {
        this.connection = this.cf.createConnection();
        this.connection.setClientID("cid");
        this.session = this.connection.createSession(false, 1);
        this.subscriber1 = this.session.createDurableSubscriber(this.topic1, "subscriber-1");
        this.subscriber2 = this.session.createDurableSubscriber(this.topic1, "subscriber-2");
        this.connection.start();
    }

    private void printPageStoreInfo(PagingStore pagingStore) throws Exception {
        this.instanceLog.debug((Object)"---------- Paging Store Info ----------");
        this.instanceLog.debug((Object)(" CurrentPage = " + pagingStore.getCurrentPage()));
        this.instanceLog.debug((Object)(" FirstPage = " + pagingStore.getFirstPage()));
        this.instanceLog.debug((Object)(" Number of Pages = " + pagingStore.getNumberOfPages()));
        this.instanceLog.debug((Object)(" Address Size = " + pagingStore.getAddressSize()));
        this.instanceLog.debug((Object)(" Is Paging = " + pagingStore.isPaging()));
    }
}

