/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OrderTest
extends ActiveMQTestBase {
    private boolean persistent;
    private ActiveMQServer server;
    private ServerLocator locator;

    public OrderTest(boolean persistent) {
        this.persistent = persistent;
    }

    @Parameterized.Parameters(name="persistent={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createNettyNonHALocator();
    }

    @Test
    public void testSimpleStorage() throws Exception {
        this.server = this.createServer(this.persistent, true);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(true);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(true, true, 0);
        session.createQueue(new QueueConfiguration("queue"));
        ClientProducer prod = session.createProducer("queue");
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = session.createMessage(i % 2 == 0);
            msg.putIntProperty("id", i);
            prod.send((Message)msg);
        }
        session.close();
        boolean started = false;
        for (int start = 0; start < 2; ++start) {
            ClientMessage msg;
            int i;
            if (this.persistent && start == 1) {
                started = true;
                this.server.stop();
                this.server.start();
                sf = this.createSessionFactory(this.locator);
            }
            session = sf.createSession(true, true);
            session.start();
            ClientConsumer cons = session.createConsumer("queue");
            for (i = 0; i < 100; ++i) {
                if (started && (!started || i % 2 != 0)) continue;
                msg = cons.receive(10000L);
                Assert.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
            }
            cons.close();
            cons = session.createConsumer("queue");
            for (i = 0; i < 100; ++i) {
                if (started && (!started || i % 2 != 0)) continue;
                msg = cons.receive(10000L);
                Assert.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
            }
            session.close();
        }
    }

    @Test
    public void testOrderOverSessionClose() throws Exception {
        int i;
        this.server = this.createServer(this.persistent, true);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(false);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(true, true, 0);
        int numberOfMessages = 500;
        session.createQueue(new QueueConfiguration("queue"));
        ClientProducer prod = session.createProducer("queue");
        for (i = 0; i < numberOfMessages; ++i) {
            ClientMessage msg = session.createMessage(i % 2 == 0);
            msg.putIntProperty("id", i);
            prod.send((Message)msg);
        }
        session.close();
        i = 0;
        while (i < numberOfMessages) {
            ClientMessage msg;
            session = sf.createSession();
            session.start();
            ClientConsumer consumer = session.createConsumer("queue");
            int max = i + 10;
            while (i < max) {
                ClientMessage msg2 = consumer.receive(1000L);
                msg2.acknowledge();
                Assert.assertEquals((long)i, (long)msg2.getIntProperty("id").intValue());
                ++i;
            }
            for (int j = 0; j < 10 && i < numberOfMessages && (msg = consumer.receiveImmediate()) != null; ++j) {
            }
            session.close();
        }
    }

    @Test
    public void testOrderOverSessionCloseWithRedeliveryDelay() throws Exception {
        ClientMessage msg;
        int i;
        this.server = this.createServer(this.persistent, true);
        this.server.getAddressSettingsRepository().clear();
        AddressSettings setting = new AddressSettings().setRedeliveryDelay(500L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)setting);
        this.server.start();
        this.locator.setBlockOnNonDurableSend(false).setBlockOnDurableSend(false).setBlockOnAcknowledge(false);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(true, true, 0);
        int numberOfMessages = 500;
        session.createQueue(new QueueConfiguration("queue"));
        ClientProducer prod = session.createProducer("queue");
        for (int i2 = 0; i2 < numberOfMessages; ++i2) {
            ClientMessage msg2 = session.createMessage(i2 % 2 == 0);
            msg2.putIntProperty("id", i2);
            prod.send((Message)msg2);
        }
        session.close();
        session = sf.createSession(false, false);
        session.start();
        ClientConsumer cons = session.createConsumer("queue");
        for (i = 0; i < numberOfMessages; ++i) {
            msg = cons.receive(5000L);
            msg.acknowledge();
            OrderTest.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
        }
        session.close();
        session = sf.createSession(false, false);
        session.start();
        cons = session.createConsumer("queue");
        for (i = 0; i < numberOfMessages; ++i) {
            msg = cons.receive(5000L);
            OrderTest.assertNotNull((Object)msg);
            msg.acknowledge();
            OrderTest.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
        }
        session.commit();
        session.close();
    }
}

