/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.EnumSet;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoutingTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString addressB = new SimpleString("addressB");
    public final SimpleString queueA = new SimpleString("queueA");
    public final SimpleString queueB = new SimpleString("queueB");
    public final SimpleString queueC = new SimpleString("queueC");
    public final SimpleString queueD = new SimpleString("queueD");
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testRouteToMultipleQueues() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        sendSession.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        sendSession.createQueue(new QueueConfiguration(this.queueC).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        int numMessages = 300;
        ClientProducer p = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            p.send((Message)sendSession.createMessage(false));
        }
        ClientSession session = this.cf.createSession(false, true, true);
        ClientConsumer c1 = session.createConsumer(this.queueA);
        ClientConsumer c2 = session.createConsumer(this.queueB);
        ClientConsumer c3 = session.createConsumer(this.queueC);
        session.start();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = c1.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
            c2.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
            c3.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        Assert.assertNull((Object)c1.receiveImmediate());
        Assert.assertNull((Object)c2.receiveImmediate());
        Assert.assertNull((Object)c3.receiveImmediate());
        sendSession.close();
        session.close();
    }

    @Test
    public void testRouteToSingleNonDurableQueue() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        int numMessages = 300;
        ClientProducer p = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            p.send((Message)sendSession.createMessage(false));
        }
        ClientSession session = this.cf.createSession(false, true, true);
        ClientConsumer c1 = session.createConsumer(this.queueA);
        session.start();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = c1.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        Assert.assertNull((Object)c1.receiveImmediate());
        sendSession.close();
        session.close();
    }

    @Test
    public void testRouteToSingleDurableQueue() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA));
        int numMessages = 300;
        ClientProducer p = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            p.send((Message)sendSession.createMessage(false));
        }
        ClientSession session = this.cf.createSession(false, true, true);
        ClientConsumer c1 = session.createConsumer(this.queueA);
        session.start();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = c1.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        Assert.assertNull((Object)c1.receiveImmediate());
        sendSession.close();
        session.close();
    }

    @Test
    public void testRouteToSingleQueueWithFilter() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setFilterString(new SimpleString("foo = 'bar'")).setDurable(Boolean.valueOf(false)));
        int numMessages = 300;
        ClientProducer p = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage clientMessage = sendSession.createMessage(false);
            clientMessage.putStringProperty(new SimpleString("foo"), new SimpleString("bar"));
            p.send((Message)clientMessage);
        }
        ClientSession session = this.cf.createSession(false, true, true);
        ClientConsumer c1 = session.createConsumer(this.queueA);
        session.start();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = c1.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        Assert.assertNull((Object)c1.receiveImmediate());
        sendSession.close();
        session.close();
    }

    @Test
    public void testRouteToMultipleQueueWithFilters() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setFilterString(new SimpleString("foo = 'bar'")).setDurable(Boolean.valueOf(false)));
        sendSession.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressA).setFilterString(new SimpleString("x = 1")).setDurable(Boolean.valueOf(false)));
        sendSession.createQueue(new QueueConfiguration(this.queueC).setAddress(this.addressA).setFilterString(new SimpleString("b = false")).setDurable(Boolean.valueOf(false)));
        int numMessages = 300;
        ClientProducer p = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage clientMessage = sendSession.createMessage(false);
            if (i % 3 == 0) {
                clientMessage.putStringProperty(new SimpleString("foo"), new SimpleString("bar"));
            } else if (i % 3 == 1) {
                clientMessage.putIntProperty(new SimpleString("x"), 1);
            } else {
                clientMessage.putBooleanProperty(new SimpleString("b"), false);
            }
            p.send((Message)clientMessage);
        }
        ClientSession session = this.cf.createSession(false, true, true);
        ClientConsumer c1 = session.createConsumer(this.queueA);
        ClientConsumer c2 = session.createConsumer(this.queueB);
        ClientConsumer c3 = session.createConsumer(this.queueC);
        session.start();
        for (int i = 0; i < numMessages / 3; ++i) {
            ClientMessage m = c1.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
            m = c2.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
            m = c3.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        Assert.assertNull((Object)c1.receiveImmediate());
        Assert.assertNull((Object)c2.receiveImmediate());
        Assert.assertNull((Object)c3.receiveImmediate());
        sendSession.close();
        session.close();
    }

    @Test
    public void testRouteToSingleTemporaryQueue() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        int numMessages = 300;
        ClientProducer p = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            p.send((Message)sendSession.createMessage(false));
        }
        ClientSession session = this.cf.createSession(false, true, true);
        ClientConsumer c1 = session.createConsumer(this.queueA);
        session.start();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = c1.receive(5000L);
            Assert.assertNotNull((Object)m);
            m.acknowledge();
        }
        Assert.assertNull((Object)c1.receiveImmediate());
        sendSession.close();
        session.close();
    }

    @Test
    public void testAnycastMessageRoutingExclusivity() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        EnumSet<RoutingType> routingTypes = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        sendSession.createAddress(this.addressA, routingTypes, false);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        sendSession.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        sendSession.createQueue(new QueueConfiguration(this.queueC).setAddress(this.addressA));
        ClientProducer p = sendSession.createProducer(this.addressA);
        ClientMessage message = sendSession.createMessage(false);
        message.setRoutingType(RoutingType.ANYCAST);
        p.send((Message)message);
        sendSession.close();
        RoutingTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.queueA).getMessageCount() + this.server.locateQueue(this.queueB).getMessageCount() == 1L));
        RoutingTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.queueC).getMessageCount() == 0L));
    }

    @Test
    public void testMulticastMessageRoutingExclusivity() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        EnumSet<RoutingType> routingTypes = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        sendSession.createAddress(this.addressA, routingTypes, false);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        sendSession.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressA));
        sendSession.createQueue(new QueueConfiguration(this.queueC).setAddress(this.addressA));
        ClientProducer p = sendSession.createProducer(this.addressA);
        ClientMessage message = sendSession.createMessage(false);
        message.setRoutingType(RoutingType.MULTICAST);
        p.send((Message)message);
        sendSession.close();
        RoutingTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.queueA).getMessageCount() == 0L));
        RoutingTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.queueB).getMessageCount() + this.server.locateQueue(this.queueC).getMessageCount() == 2L));
    }

    @Test
    public void testAmbiguousMessageRouting() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        EnumSet<RoutingType> routingTypes = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        sendSession.createAddress(this.addressA, routingTypes, false);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        sendSession.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        sendSession.createQueue(new QueueConfiguration(this.queueC).setAddress(this.addressA));
        sendSession.createQueue(new QueueConfiguration(this.queueD).setAddress(this.addressA));
        ClientProducer p = sendSession.createProducer(this.addressA);
        ClientMessage message = sendSession.createMessage(false);
        p.send((Message)message);
        sendSession.close();
        RoutingTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.queueA).getMessageCount() + this.server.locateQueue(this.queueB).getMessageCount() == 1L));
        RoutingTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.queueC).getMessageCount() + this.server.locateQueue(this.queueD).getMessageCount() == 2L));
    }
}

