/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.tests.integration.clientcrash.ClientCrashTest;
import org.jboss.logging.Logger;

public class CrashClient {
    private static final Logger log = Logger.getLogger(CrashClient.class);
    public static int OK = 9;
    public static int NOT_OK = 1;

    public static void main(String[] args) throws Exception {
        try {
            ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName())});
            locator.setClientFailureCheckPeriod(100L);
            locator.setConnectionTTL(1000L);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(false, true, true);
            ClientProducer producer = session.createProducer(ClientCrashTest.QUEUE);
            ClientMessage message = session.createMessage((byte)3, true, 0L, System.currentTimeMillis(), (byte)1);
            message.getBodyBuffer().writeString("ClientCrashTest from client");
            producer.send((Message)message);
            System.exit(OK);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            System.exit(NOT_OK);
        }
    }
}

