/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.tests.integration.clientcrash.ClientCrashTest;
import org.jboss.logging.Logger;

public class CrashClient2 {
    private static final Logger log = Logger.getLogger(CrashClient2.class);
    public static final int OK = 9;

    public static void main(String[] args) throws Exception {
        try {
            ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName())});
            locator.setClientFailureCheckPeriod(100L);
            locator.setConnectionTTL(1000L);
            ClientSessionFactory sf = locator.createSessionFactory();
            ClientSession session = sf.createSession(true, true, 1000000);
            ClientProducer producer = session.createProducer(ClientCrashTest.QUEUE2);
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeString("ClientCrashTest from client");
            producer.send((Message)message);
            ClientConsumer cons = session.createConsumer(ClientCrashTest.QUEUE2);
            session.start();
            ClientMessage msg = cons.receive(10000L);
            if (msg == null) {
                log.error((Object)"Didn't receive msg");
                System.exit(1);
            }
            System.exit(9);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            System.exit(1);
        }
    }
}

