/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ExtraBackupReplicatedFailoverTest
extends FailoverTestBase {
    boolean isExtraBackupGroupNameReplicates = false;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            ExtraBackupReplicatedFailoverTest.this.isExtraBackupGroupNameReplicates = description.getMethodName().equals("testExtraBackupGroupNameReplicates");
        }
    };

    @Test
    public void testExtraBackupReplicates() throws Exception {
        Configuration secondBackupConfig = this.backupConfig.copy();
        TransportConfiguration tc = (TransportConfiguration)secondBackupConfig.getAcceptorConfigurations().iterator().next();
        TestableServer secondBackupServer = this.createTestableServer(secondBackupConfig);
        tc.getParams().put("serverId", "2");
        secondBackupConfig.setBindingsDirectory(this.getBindingsDir(1, true)).setJournalDirectory(this.getJournalDir(1, true)).setPagingDirectory(this.getPageDir(1, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(1, true)).setSecurityEnabled(false);
        ExtraBackupReplicatedFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)this.backupServer.getServer());
        secondBackupServer.start();
        Thread.sleep(5000L);
        this.backupServer.stop();
        this.waitForSync(secondBackupServer.getServer());
        ExtraBackupReplicatedFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)secondBackupServer.getServer());
    }

    @Test
    public void testExtraBackupGroupNameReplicates() throws Exception {
        ReplicaPolicyConfiguration backupReplicaPolicyConfiguration = (ReplicaPolicyConfiguration)this.backupServer.getServer().getConfiguration().getHAPolicyConfiguration();
        backupReplicaPolicyConfiguration.setGroupName("foo");
        ReplicatedPolicyConfiguration replicatedPolicyConfiguration = (ReplicatedPolicyConfiguration)this.liveServer.getServer().getConfiguration().getHAPolicyConfiguration();
        replicatedPolicyConfiguration.setGroupName("foo");
        Configuration secondBackupConfig = this.backupConfig.copy();
        TransportConfiguration tc = (TransportConfiguration)secondBackupConfig.getAcceptorConfigurations().iterator().next();
        TestableServer secondBackupServer = this.createTestableServer(secondBackupConfig);
        tc.getParams().put("serverId", "2");
        secondBackupConfig.setBindingsDirectory(this.getBindingsDir(1, true)).setJournalDirectory(this.getJournalDir(1, true)).setPagingDirectory(this.getPageDir(1, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(1, true)).setSecurityEnabled(false);
        ReplicaPolicyConfiguration replicaPolicyConfiguration = (ReplicaPolicyConfiguration)secondBackupConfig.getHAPolicyConfiguration();
        replicaPolicyConfiguration.setGroupName("foo");
        ExtraBackupReplicatedFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)this.backupServer.getServer());
        secondBackupServer.start();
        Thread.sleep(5000L);
        this.backupServer.stop();
        this.waitForSync(secondBackupServer.getServer());
        ExtraBackupReplicatedFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)secondBackupServer.getServer());
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        if (this.isExtraBackupGroupNameReplicates) {
            ((ReplicatedPolicyConfiguration)this.liveConfig.getHAPolicyConfiguration()).setGroupName("foo");
            ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setGroupName("foo");
        }
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    private void waitForSync(ActiveMQServer server) throws Exception {
        Wait.waitFor(() -> ((ActiveMQServer)server).isReplicaSync());
    }
}

