/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.MultipleBackupsFailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.junit.Test;

public class MultipleLivesMultipleBackupsFailoverTest
extends MultipleBackupsFailoverTestBase {
    protected Map<Integer, TestableServer> servers = new HashMap<Integer, TestableServer>();
    private ServerLocator locator2;
    private ServerLocator locator;
    private final boolean sharedStore = true;

    @Test
    public void testMultipleFailovers2LiveServers() throws Exception {
        InVMNodeManager nodeManager1 = new InVMNodeManager(false);
        InVMNodeManager nodeManager2 = new InVMNodeManager(false);
        this.createLiveConfig((NodeManager)nodeManager1, 0, 3, 4, 5);
        this.createBackupConfig((NodeManager)nodeManager1, 0, 1, true, new int[]{0, 2}, 3, 4, 5);
        this.createBackupConfig((NodeManager)nodeManager1, 0, 2, true, new int[]{0, 1}, 3, 4, 5);
        this.createLiveConfig((NodeManager)nodeManager2, 3, 0);
        this.createBackupConfig((NodeManager)nodeManager2, 3, 4, true, new int[]{3, 5}, 0, 1, 2);
        this.createBackupConfig((NodeManager)nodeManager2, 3, 5, true, new int[]{3, 4}, 0, 1, 2);
        this.servers.get(0).start();
        this.waitForServerToStart(this.servers.get(0).getServer());
        this.servers.get(3).start();
        this.waitForServerToStart(this.servers.get(3).getServer());
        this.servers.get(1).start();
        this.waitForServerToStart(this.servers.get(1).getServer());
        this.servers.get(2).start();
        this.servers.get(4).start();
        this.waitForServerToStart(this.servers.get(4).getServer());
        this.servers.get(5).start();
        this.waitForServerToStart(this.servers.get(4).getServer());
        this.locator = this.getServerLocator(0).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(15);
        ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology(this.locator, 4, this.servers.get(0).getServer());
        ClientSession session = this.sendAndConsume((ClientSessionFactory)sf, true);
        this.instanceLog.debug((Object)((ServerLocatorInternal)this.locator).getTopology().describe());
        Thread.sleep(500L);
        this.servers.get(0).crash(session);
        int liveAfter0 = this.waitForNewLive(10000L, true, this.servers, 1, 2);
        this.locator2 = this.getServerLocator(3).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(15);
        ClientSessionFactoryInternal sf2 = this.createSessionFactoryAndWaitForTopology(this.locator2, 4);
        ClientSession session2 = this.sendAndConsume((ClientSessionFactory)sf2, true);
        System.setProperty("foo", "bar");
        this.servers.get(3).crash(session2);
        int liveAfter3 = this.waitForNewLive(10000L, true, this.servers, 4, 5);
        this.locator.close();
        this.locator2.close();
        if (liveAfter0 == 2) {
            Thread.sleep(500L);
            this.servers.get(1).stop();
            Thread.sleep(500L);
            this.servers.get(2).stop();
        } else {
            Thread.sleep(500L);
            this.servers.get(2).stop();
            Thread.sleep(500L);
            this.servers.get(1).stop();
        }
        if (liveAfter3 == 4) {
            Thread.sleep(500L);
            this.servers.get(5).stop();
            Thread.sleep(500L);
            this.servers.get(4).stop();
        } else {
            Thread.sleep(500L);
            this.servers.get(4).stop();
            Thread.sleep(500L);
            this.servers.get(5).stop();
        }
    }

    protected void createBackupConfig(NodeManager nodeManager, int liveNode, int nodeid, boolean createClusterConnections, int[] otherBackupNodes, int ... otherClusterNodes) throws Exception {
        Configuration config1 = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(MultipleLivesMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)true, (Map)MultipleLivesMultipleBackupsFailoverTest.generateParams((int)nodeid, (boolean)this.isNetty()))).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration()).setBindingsDirectory(this.getBindingsDir() + "_" + liveNode).setJournalDirectory(this.getJournalDir() + "_" + liveNode).setPagingDirectory(this.getPageDir() + "_" + liveNode).setLargeMessagesDirectory(this.getLargeMessagesDir() + "_" + liveNode);
        for (int node : otherBackupNodes) {
            TransportConfiguration liveConnector = MultipleLivesMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)MultipleLivesMultipleBackupsFailoverTest.generateParams((int)node, (boolean)this.isNetty()));
            config1.addConnectorConfiguration(liveConnector.getName(), liveConnector);
        }
        TransportConfiguration backupConnector = MultipleLivesMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)MultipleLivesMultipleBackupsFailoverTest.generateParams((int)nodeid, (boolean)this.isNetty()));
        config1.addConnectorConfiguration(backupConnector.getName(), backupConnector);
        String[] clusterNodes = new String[otherClusterNodes.length];
        for (int i = 0; i < otherClusterNodes.length; ++i) {
            TransportConfiguration connector = MultipleLivesMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)MultipleLivesMultipleBackupsFailoverTest.generateParams((int)otherClusterNodes[i], (boolean)this.isNetty()));
            config1.addConnectorConfiguration(connector.getName(), connector);
            clusterNodes[i] = connector.getName();
        }
        config1.addClusterConfiguration(MultipleLivesMultipleBackupsFailoverTest.basicClusterConnectionConfig((String)backupConnector.getName(), (String[])clusterNodes));
        this.servers.put(nodeid, new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config1, nodeManager, liveNode)));
    }

    protected void createLiveConfig(NodeManager nodeManager, int liveNode, int ... otherLiveNodes) throws Exception {
        TransportConfiguration liveConnector = MultipleLivesMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)MultipleLivesMultipleBackupsFailoverTest.generateParams((int)liveNode, (boolean)this.isNetty()));
        Configuration config0 = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(MultipleLivesMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)true, (Map)MultipleLivesMultipleBackupsFailoverTest.generateParams((int)liveNode, (boolean)this.isNetty()))).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).setBindingsDirectory(this.getBindingsDir() + "_" + liveNode).setJournalDirectory(this.getJournalDir() + "_" + liveNode).setPagingDirectory(this.getPageDir() + "_" + liveNode).setLargeMessagesDirectory(this.getLargeMessagesDir() + "_" + liveNode).addConnectorConfiguration(liveConnector.getName(), liveConnector);
        String[] pairs = new String[otherLiveNodes.length];
        for (int i = 0; i < otherLiveNodes.length; ++i) {
            TransportConfiguration otherLiveConnector = MultipleLivesMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)MultipleLivesMultipleBackupsFailoverTest.generateParams((int)otherLiveNodes[i], (boolean)this.isNetty()));
            config0.addConnectorConfiguration(otherLiveConnector.getName(), otherLiveConnector);
            pairs[i] = otherLiveConnector.getName();
        }
        config0.addClusterConfiguration(MultipleLivesMultipleBackupsFailoverTest.basicClusterConnectionConfig((String)liveConnector.getName(), (String[])pairs));
        this.servers.put(liveNode, new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config0, nodeManager, liveNode)));
    }

    @Override
    protected boolean isNetty() {
        return false;
    }
}

