/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FakeServiceComponent;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NetworkIsolationTest
extends FailoverTestBase {
    private static final Logger logger = Logger.getLogger(NetworkIsolationTest.class);
    private static final String badAddress = "203.0.113.1";

    @Override
    @Before
    public void setUp() throws Exception {
        this.startBackupServer = false;
        super.setUp();
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getNettyAcceptor(live, 1);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getNettyConnector(live, 1);
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(xa, autoCommitSends, autoCommitAcks));
    }

    @Test
    public void testReactivate() throws Exception {
        this.liveServer.getServer().getConfiguration().setNetworkCheckPeriod(100L).setNetworkCheckTimeout(200);
        this.liveServer.start();
        Assert.assertTrue((boolean)Wait.waitFor(this.liveServer::isActive));
        this.liveServer.getServer().getNetworkHealthCheck().addAddress(badAddress);
        Wait.assertFalse(() -> ((TestableServer)this.liveServer).isStarted());
        this.liveServer.getServer().getNetworkHealthCheck().clearAddresses();
        Assert.assertTrue((boolean)Wait.waitFor(() -> ((TestableServer)this.liveServer).isStarted()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoNotActivateOnIsolation() throws Exception {
        AssertionLoggerHandler.startCapture();
        try {
            int i;
            ServerLocatorInternal locator = this.getServerLocator();
            this.backupServer.getServer().getNetworkHealthCheck().addAddress("127.0.0.1");
            Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ202001"}));
            AssertionLoggerHandler.clear();
            this.backupServer.getServer().getNetworkHealthCheck().setIgnoreLoopback(true).addAddress("127.0.0.1");
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ202001"}));
            this.backupServer.getServer().getNetworkHealthCheck().clearAddresses();
            this.backupServer.getServer().getNetworkHealthCheck().addAddress(badAddress);
            this.backupServer.getServer().start();
            ClientSessionFactory sf = this.addSessionFactory(locator.createSessionFactory());
            ClientSession session = this.createSession(sf, false, true, true);
            session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
            Assert.assertFalse((boolean)this.backupServer.getServer().getNetworkHealthCheck().check());
            this.crash(false, true, session);
            for (i = 0; i < 1000 && !this.backupServer.isStarted(); ++i) {
                Thread.sleep(10L);
            }
            Assert.assertTrue((boolean)this.backupServer.isStarted());
            Assert.assertFalse((boolean)this.backupServer.isActive());
            this.liveServer.start();
            for (i = 0; i < 1000 && NetworkIsolationTest.getReplicationEndpoint((ActiveMQServer)this.backupServer.getServer()) != null && !NetworkIsolationTest.getReplicationEndpoint((ActiveMQServer)this.backupServer.getServer()).isStarted(); ++i) {
                Thread.sleep(10L);
            }
            this.backupServer.getServer().getNetworkHealthCheck().clearAddresses();
            Assert.assertTrue((boolean)NetworkIsolationTest.getReplicationEndpoint((ActiveMQServer)this.backupServer.getServer()).isStarted());
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    @Test
    public void testLiveIsolated() throws Exception {
        this.backupServer.stop();
        FakeServiceComponent component = new FakeServiceComponent("Component for " + this.getName());
        this.liveServer.getServer().addExternalComponent((ActiveMQComponent)component, true);
        this.liveServer.getServer().getConfiguration().setNetworkCheckList(badAddress).setNetworkCheckPeriod(100L).setNetworkCheckTimeout(100);
        ((ActiveMQServerImpl)this.liveServer.getServer()).reloadNetworkHealthCheck();
        try {
            Assert.assertEquals((long)100L, (long)this.liveServer.getServer().getNetworkHealthCheck().getPeriod());
            this.liveServer.getServer().getNetworkHealthCheck().setTimeUnit(TimeUnit.MILLISECONDS);
            Assert.assertFalse((boolean)this.liveServer.getServer().getNetworkHealthCheck().check());
            Wait.assertFalse(() -> ((TestableServer)this.liveServer).isStarted());
            this.liveServer.getServer().getNetworkHealthCheck().setIgnoreLoopback(true).addAddress("127.0.0.1");
            Wait.assertTrue(() -> ((TestableServer)this.liveServer).isStarted());
            Assert.assertTrue((boolean)component.isStarted());
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
            throw e;
        }
        finally {
            this.liveServer.getServer().stop();
            this.backupServer.getServer().stop();
        }
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected void crash(boolean failover, boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                NetworkIsolationTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
            }
        } else {
            NetworkIsolationTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        }
        super.crash(failover, waitFailure, sessions);
    }
}

