/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVoteServerConnect;
import org.apache.activemq.artemis.core.server.cluster.qourum.ServerConnectVote;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class QuorumVoteServerConnectTest
extends ActiveMQTestBase {
    private final int size;
    private final int trueVotes;

    @Parameterized.Parameters(name="size={0} trueVotes={1}")
    public static Collection primeNumbers() {
        return Arrays.asList({1, 0}, {2, 1}, {3, 2}, {4, 3}, {5, 3}, {6, 4}, {7, 4}, {8, 5}, {9, 5}, {10, 6});
    }

    public QuorumVoteServerConnectTest(int size, int trueVotes) {
        this.size = size;
        this.trueVotes = trueVotes;
    }

    @Test
    public void testVoteOnRequestToStay() {
        Assume.assumeThat((Object)this.trueVotes, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assume.assumeThat((Object)this.size, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(this.trueVotes)));
        String liveConnector = "live";
        String backupConnector = "backup";
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo", true, "live");
        quorum.vote(new ServerConnectVote("foo", true, "backup"));
        Assert.assertFalse((boolean)quorum.getDecision());
        for (int i = 0; i < this.trueVotes - 1; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, "live"));
            Assert.assertFalse((boolean)quorum.getDecision());
        }
        quorum.vote(new ServerConnectVote("foo", true, "live"));
        Assert.assertTrue((boolean)quorum.getDecision());
    }

    @Test
    public void testAllVoteCastFreezeNotRequestToStayDecision() {
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        Assert.assertFalse((boolean)quorum.isRequestToStayLive());
        boolean decisionBeforeVoteCompleted = quorum.getDecision();
        quorum.allVotesCast(null);
        for (int i = 0; i < this.trueVotes; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        Assert.assertEquals((Object)decisionBeforeVoteCompleted, (Object)quorum.getDecision());
    }

    @Test
    public void testAllVoteCastFreezeRequestToStayDecision() {
        String liveConnector = "live";
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo", true, "live");
        Assert.assertTrue((boolean)quorum.isRequestToStayLive());
        boolean decisionBeforeVoteCompleted = quorum.getDecision();
        quorum.allVotesCast(null);
        for (int i = 0; i < this.trueVotes; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, "live"));
        }
        Assert.assertEquals((Object)decisionBeforeVoteCompleted, (Object)quorum.getDecision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllVoteCastUnblockAwait() throws InterruptedException {
        Assume.assumeThat((Object)this.trueVotes, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assume.assumeThat((Object)this.size, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(this.trueVotes)));
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        Assert.assertFalse((boolean)quorum.getDecision());
        CountDownLatch taskStarted = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<InterruptedException> waitingTaskResult = executor.submit(() -> {
                taskStarted.countDown();
                try {
                    quorum.await(1, TimeUnit.DAYS);
                    return null;
                }
                catch (InterruptedException e) {
                    return e;
                }
            });
            Assert.assertTrue((boolean)taskStarted.await(10L, TimeUnit.SECONDS));
            Assert.assertFalse((boolean)waitingTaskResult.isDone());
            quorum.allVotesCast(null);
            try {
                Assert.assertNull((Object)waitingTaskResult.get(5L, TimeUnit.SECONDS));
            }
            catch (TimeoutException ex) {
                Assert.fail((String)"allVoteCast hasn't unblocked the waiting task");
            }
            catch (ExecutionException ex) {
                Assert.fail((String)("This shouldn't really happen: the wait task shouldn't throw any exception: " + ex));
            }
            Assert.assertTrue((boolean)waitingTaskResult.isDone());
            Assert.assertFalse((boolean)quorum.getDecision());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestToStayQuorumUnblockAwait() throws InterruptedException {
        Assume.assumeThat((Object)this.trueVotes, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assume.assumeThat((Object)this.size, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(this.trueVotes)));
        String liveConnector = "live";
        String backupConnector = "backup";
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo", true, "live");
        Assert.assertFalse((boolean)quorum.getDecision());
        CountDownLatch taskStarted = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<InterruptedException> waitingTaskResult = executor.submit(() -> {
                taskStarted.countDown();
                try {
                    quorum.await(1, TimeUnit.DAYS);
                    return null;
                }
                catch (InterruptedException e) {
                    return e;
                }
            });
            Assert.assertTrue((boolean)taskStarted.await(10L, TimeUnit.SECONDS));
            quorum.vote(new ServerConnectVote("foo", true, "backup"));
            Assert.assertFalse((boolean)waitingTaskResult.isDone());
            Assert.assertFalse((boolean)quorum.getDecision());
            for (int i = 0; i < this.trueVotes - 1; ++i) {
                quorum.vote(new ServerConnectVote("foo", true, "live"));
                Assert.assertFalse((boolean)waitingTaskResult.isDone());
                Assert.assertFalse((boolean)quorum.getDecision());
            }
            quorum.vote(new ServerConnectVote("foo", true, "live"));
            Assert.assertTrue((boolean)quorum.getDecision());
            try {
                Assert.assertNull((Object)waitingTaskResult.get(5L, TimeUnit.SECONDS));
            }
            catch (TimeoutException ex) {
                Assert.fail((String)"allVoteCast hasn't unblocked the waiting task");
            }
            catch (ExecutionException ex) {
                Assert.fail((String)("This shouldn't really happen: the wait task shouldn't throw any exception: " + ex));
            }
            Assert.assertTrue((boolean)waitingTaskResult.isDone());
            Assert.assertTrue((boolean)quorum.getDecision());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotRequestToStayQuorumUnblockAwait() throws InterruptedException {
        Assume.assumeThat((Object)this.trueVotes, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assume.assumeThat((Object)this.size, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(this.trueVotes)));
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        Assert.assertFalse((boolean)quorum.getDecision());
        CountDownLatch taskStarted = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<InterruptedException> waitingTaskResult = executor.submit(() -> {
                taskStarted.countDown();
                try {
                    quorum.await(1, TimeUnit.DAYS);
                    return null;
                }
                catch (InterruptedException e) {
                    return e;
                }
            });
            Assert.assertTrue((boolean)taskStarted.await(10L, TimeUnit.SECONDS));
            quorum.vote(new ServerConnectVote("foo", false, null));
            Assert.assertFalse((boolean)waitingTaskResult.isDone());
            Assert.assertFalse((boolean)quorum.getDecision());
            for (int i = 0; i < this.trueVotes - 1; ++i) {
                quorum.vote(new ServerConnectVote("foo", true, null));
                Assert.assertFalse((boolean)waitingTaskResult.isDone());
                Assert.assertFalse((boolean)quorum.getDecision());
            }
            quorum.vote(new ServerConnectVote("foo", true, null));
            Assert.assertTrue((boolean)quorum.getDecision());
            try {
                Assert.assertNull((Object)waitingTaskResult.get(5L, TimeUnit.SECONDS));
            }
            catch (TimeoutException ex) {
                Assert.fail((String)"allVoteCast hasn't unblocked the waiting task");
            }
            catch (ExecutionException ex) {
                Assert.fail((String)("This shouldn't really happen: the wait task shouldn't throw any exception: " + ex));
            }
            Assert.assertTrue((boolean)waitingTaskResult.isDone());
            Assert.assertTrue((boolean)quorum.getDecision());
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testSuccessfulVote() {
        int i;
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        for (i = 0; i < this.trueVotes - 1; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        if (this.size > 1) {
            QuorumVoteServerConnectTest.assertFalse((boolean)quorum.getDecision());
        }
        quorum = new QuorumVoteServerConnect(this.size, "foo");
        for (i = 0; i < this.trueVotes; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        QuorumVoteServerConnectTest.assertTrue((boolean)quorum.getDecision());
    }

    @Test
    public void testUnSuccessfulVote() {
        int i;
        QuorumVoteServerConnect quorum = new QuorumVoteServerConnect(this.size, "foo");
        for (i = 0; i < this.trueVotes - 1; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        if (this.size > 1) {
            QuorumVoteServerConnectTest.assertFalse((boolean)quorum.getDecision());
        }
        quorum = new QuorumVoteServerConnect(this.size, "foo");
        for (i = 0; i < this.trueVotes - 1; ++i) {
            quorum.vote(new ServerConnectVote("foo", true, null));
        }
        if (this.size == 1) {
            QuorumVoteServerConnectTest.assertTrue((boolean)quorum.getDecision());
        } else {
            QuorumVoteServerConnectTest.assertFalse((boolean)quorum.getDecision());
        }
    }
}

