/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.server.impl.ReplicationBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReplicaTimeoutTest
extends ActiveMQTestBase {
    protected ServerLocator locator;
    protected static final SimpleString ADDRESS = new SimpleString("FailoverTestAddress");

    @Before
    public void setup() {
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{this.getConnectorTransportConfiguration(true), this.getConnectorTransportConfiguration(false)})).setRetryInterval(50L);
    }

    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    protected NodeManager createReplicatedBackupNodeManager(Configuration backupConfig) {
        return new InVMNodeManager(true, backupConfig.getJournalLocation());
    }

    protected TestableServer createTestableServer(Configuration config, NodeManager nodeManager) throws Exception {
        boolean isBackup = config.getHAPolicyConfiguration() instanceof ReplicationBackupPolicyConfiguration || config.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration || config.getHAPolicyConfiguration() instanceof SharedStoreSlavePolicyConfiguration;
        return new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config, nodeManager, isBackup ? 2 : 1));
    }

    protected ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, int topologyMembers) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers);
        locator.addClusterTopologyListener((ClusterTopologyListener)new FailoverTestBase.LatchClusterTopologyListener(countDownLatch));
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        this.addSessionFactory((ClientSessionFactory)sf);
        Assert.assertTrue((String)("topology members expected " + topologyMembers), (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
        return sf;
    }

    protected ClientSessionFactoryInternal createSessionFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        return this.createSessionFactoryAndWaitForTopology(this.locator, 2);
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks));
    }

    protected void crash(TestableServer liveServer, TestableServer backupServer, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                ReplicaTimeoutTest.waitForRemoteBackup((ClientSessionFactory)session.getSessionFactory(), (int)5, (boolean)true, (ActiveMQServer)backupServer.getServer());
            }
        } else {
            ReplicaTimeoutTest.waitForRemoteBackup(null, (int)5, (boolean)true, (ActiveMQServer)backupServer.getServer());
        }
        liveServer.crash(true, true, sessions);
    }

    protected void configureReplicationPair(Configuration backupConfig, Configuration liveConfig, TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, TransportConfiguration liveConnector) throws IOException {
        ReplicatedBackupUtils.configureReplicationPair(backupConfig, backupConnector, backupAcceptor, liveConfig, liveConnector, null);
        ((ReplicatedPolicyConfiguration)liveConfig.getHAPolicyConfiguration()).setInitialReplicationSyncTimeout(1000L);
        ((ReplicaPolicyConfiguration)backupConfig.getHAPolicyConfiguration()).setInitialReplicationSyncTimeout(1000L);
        ((ReplicatedPolicyConfiguration)liveConfig.getHAPolicyConfiguration()).setCheckForLiveServer(true);
        ((ReplicaPolicyConfiguration)backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
        ((ReplicaPolicyConfiguration)backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailbackTimeout() throws Exception {
        AssertionLoggerHandler.startCapture();
        try {
            TestableServer backupServer = null;
            TestableServer liveServer = null;
            ClientSessionFactoryInternal sf = null;
            try {
                TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
                TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
                TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
                Configuration backupConfig = this.createDefaultInVMConfig();
                Configuration liveConfig = this.createDefaultInVMConfig();
                this.configureReplicationPair(backupConfig, liveConfig, backupConnector, backupAcceptor, liveConnector);
                backupConfig.setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setSecurityEnabled(false);
                liveConfig.setBindingsDirectory(this.getBindingsDir(0, false)).setJournalDirectory(this.getJournalDir(0, false)).setPagingDirectory(this.getPageDir(0, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, false)).setSecurityEnabled(false);
                NodeManager replicatedBackupNodeManager = this.createReplicatedBackupNodeManager(backupConfig);
                backupServer = this.createTestableServer(backupConfig, replicatedBackupNodeManager);
                liveConfig.clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
                NodeManager nodeManager = this.createReplicatedBackupNodeManager(liveConfig);
                liveServer = this.createTestableServer(liveConfig, nodeManager);
                final TestableServer theBackup = backupServer;
                liveServer.start();
                backupServer.start();
                Wait.assertTrue(() -> ((ActiveMQServer)backupServer.getServer()).isReplicaSync());
                sf = this.createSessionFactory();
                ClientSession session = this.createSession((ClientSessionFactory)sf, true, true);
                session.createQueue(new QueueConfiguration(ADDRESS));
                this.crash(liveServer, backupServer, session);
                Wait.assertTrue(() -> ((ActiveMQServer)backupServer.getServer()).isActive());
                ((ActiveMQServerImpl)backupServer.getServer()).setAfterActivationCreated(new Runnable(){

                    @Override
                    public void run() {
                        Activation backupActivation = theBackup.getServer().getActivation();
                        if (backupActivation instanceof SharedNothingBackupActivation) {
                            SharedNothingBackupActivation activation = (SharedNothingBackupActivation)backupActivation;
                            ReplicationEndpoint repEnd = activation.getReplicationEndpoint();
                            repEnd.addOutgoingInterceptorForReplication((packet, connection) -> packet.getType() != -9);
                        } else if (backupActivation instanceof ReplicationBackupActivation) {
                            ReplicationBackupActivation activation = (ReplicationBackupActivation)backupActivation;
                            activation.spyReplicationEndpointCreation(replicationEndpoint -> replicationEndpoint.addOutgoingInterceptorForReplication((packet, connection) -> packet.getType() != -9));
                        }
                    }
                });
                liveServer.start();
                Assert.assertTrue((boolean)Wait.waitFor(() -> AssertionLoggerHandler.findText((String[])new String[]{"AMQ229114"})));
                if (this.expectLiveSuicide()) {
                    Wait.assertFalse(() -> ((ActiveMQServer)liveServer.getServer()).isStarted());
                }
            }
            finally {
                if (sf != null) {
                    sf.close();
                }
                try {
                    liveServer.getServer().stop();
                }
                catch (Throwable throwable) {}
                try {
                    backupServer.getServer().stop();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    protected boolean expectLiveSuicide() {
        return true;
    }
}

