/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.quorum;

import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.tests.integration.cluster.failover.quorum.PluggableQuorumReplicatedLargeMessageFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.BackupSyncDelay;
import org.junit.After;
import org.junit.Before;

public class PluggableQuorumReplicatedLargeMessageWithDelayFailoverTest
extends PluggableQuorumReplicatedLargeMessageFailoverTest {
    private BackupSyncDelay syncDelay;

    @Override
    protected boolean supportsRetention() {
        return false;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.startBackupServer = false;
        super.setUp();
        this.syncDelay = new BackupSyncDelay(this.backupServer, this.liveServer);
        if (!this.getName().equals("testBackupServerNotRemoved")) {
            this.backupServer.start();
        }
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        this.crash(true, sessions);
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        this.syncDelay.deliverUpToDateMsg();
        this.waitForBackup(null, 30);
        super.crash(waitFailure, sessions);
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.syncDelay.deliverUpToDateMsg();
        super.tearDown();
    }
}

