/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WildcardTest
extends JMSTestBase {
    private String topicA;
    private String topicB;
    private String topicWildcard;

    @Parameterized.Parameters(name="a={0},b={1},c={2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"test.topic.A", "test.topic.B", "test.topic.#"}, {"test.topic.A", "test.topic.B", "test.#"});
    }

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        Configuration configuration = super.createDefaultConfig(netty).setJMXManagementEnabled(true);
        return configuration;
    }

    public WildcardTest(String topicA, String topicB, String topicWildcard) {
        this.topicA = topicA;
        this.topicB = topicB;
        this.topicWildcard = topicWildcard;
    }

    @Test
    public void testWildcard1Topic() throws Exception {
        Session sessionA = this.createSession();
        MessageProducer producerA = this.createProducer(sessionA, this.topicA);
        MessageConsumer consumerA = this.createConsumer(this.topicA);
        MessageConsumer consumerWC = this.createConsumer(this.topicWildcard);
        ObjectMessage message = sessionA.createObjectMessage((Serializable)Integer.valueOf(1));
        producerA.send((Message)message);
        ObjectMessage received1 = (ObjectMessage)consumerA.receive(500L);
        Assert.assertNotNull((Object)received1);
        Assert.assertNotNull((Object)received1.getObject());
        ObjectMessage received2 = (ObjectMessage)consumerWC.receive(500L);
        Assert.assertNotNull((Object)received2);
        Assert.assertNotNull((Object)received2.getObject());
        Assert.assertEquals((Object)received1.getJMSMessageID(), (Object)received2.getJMSMessageID());
        Assert.assertEquals((Object)received1.getObject(), (Object)received2.getObject());
    }

    @Test
    public void testWildcard2Topics() throws Exception {
        Session sessionA = this.createSession();
        MessageProducer producerA = this.createProducer(sessionA, this.topicA);
        Session sessionB = this.createSession();
        MessageProducer producerB = this.createProducer(sessionA, this.topicB);
        MessageConsumer consumerA = this.createConsumer(this.topicA);
        MessageConsumer consumerB = this.createConsumer(this.topicB);
        MessageConsumer consumerWC = this.createConsumer(this.topicWildcard);
        ObjectMessage message1 = sessionA.createObjectMessage((Serializable)Integer.valueOf(1));
        producerA.send((Message)message1);
        ObjectMessage message2 = sessionB.createObjectMessage((Serializable)Integer.valueOf(2));
        producerB.send((Message)message2);
        ObjectMessage received1 = (ObjectMessage)consumerA.receive(500L);
        Assert.assertNotNull((Object)received1);
        Assert.assertNotNull((Object)received1.getObject());
        ObjectMessage received2 = (ObjectMessage)consumerB.receive(500L);
        Assert.assertNotNull((Object)received2);
        Assert.assertNotNull((Object)received2.getObject());
        ObjectMessage received3 = (ObjectMessage)consumerWC.receive(500L);
        Assert.assertNotNull((Object)received3);
        Assert.assertNotNull((Object)received3.getObject());
        ObjectMessage received4 = (ObjectMessage)consumerWC.receive(500L);
        Assert.assertNotNull((Object)received4);
        Assert.assertNotNull((Object)received4.getObject());
        Assert.assertEquals((Object)received1.getJMSMessageID(), (Object)received3.getJMSMessageID());
        Assert.assertEquals((Object)received1.getObject(), (Object)received3.getObject());
        Assert.assertEquals((Object)received2.getJMSMessageID(), (Object)received4.getJMSMessageID());
        Assert.assertEquals((Object)received2.getObject(), (Object)received4.getObject());
    }

    @Test
    public void testNegativeAddressSizeOnWildcard1() throws Exception {
        this.testNegativeAddressSizeOnWildcard(1);
    }

    @Test
    public void testNegativeAddressSizeOnWildcard2() throws Exception {
        this.testNegativeAddressSizeOnWildcard(2);
    }

    @Test
    public void testNegativeAddressSizeOnWildcard10() throws Exception {
        this.testNegativeAddressSizeOnWildcard(10);
    }

    @Test
    public void testNegativeAddressSizeOnWildcard100() throws Exception {
        this.testNegativeAddressSizeOnWildcard(100);
    }

    @Test
    public void testNegativeAddressSizeOnWildcardAsync1() throws Exception {
        this.testNegativeAddressSizeOnWildcardAsync(1);
    }

    @Test
    public void testNegativeAddressSizeOnWildcardAsync2() throws Exception {
        this.testNegativeAddressSizeOnWildcardAsync(2);
    }

    @Test
    public void testNegativeAddressSizeOnWildcardAsync10() throws Exception {
        this.testNegativeAddressSizeOnWildcardAsync(10);
    }

    @Test
    public void testNegativeAddressSizeOnWildcardAsync100() throws Exception {
        this.testNegativeAddressSizeOnWildcardAsync(100);
    }

    private void testNegativeAddressSizeOnWildcard(int numMessages) throws Exception {
        int i;
        Session sessionA = this.createSession();
        MessageProducer producerA = this.createProducer(sessionA, this.topicA);
        MessageConsumer consumerA = this.createConsumer(this.topicA);
        MessageConsumer consumerWC = this.createConsumer(this.topicWildcard);
        for (i = 0; i < numMessages; ++i) {
            ObjectMessage message = sessionA.createObjectMessage((Serializable)Integer.valueOf(i));
            producerA.send((Message)message);
        }
        for (i = 0; i < numMessages; ++i) {
            ObjectMessage received1 = (ObjectMessage)consumerA.receive(500L);
            Assert.assertNotNull((String)("consumerA message - " + i + " is null"), (Object)received1);
            Assert.assertNotNull((String)("consumerA message - " + i + " is null"), (Object)received1.getObject());
            ObjectMessage received2 = (ObjectMessage)consumerWC.receive(500L);
            Assert.assertNotNull((String)("consumerWC message - " + i + " is null"), (Object)received2);
            Assert.assertNotNull((String)("consumerWC message - " + i + " is null"), (Object)received2.getObject());
        }
        long addressSizeA = (Long)this.mbeanServer.getAttribute(new ObjectName("org.apache.activemq.artemis:broker=\"localhost\",component=addresses,address=\"" + this.topicA + "\""), "AddressSize");
        long addressSizeWC = (Long)this.mbeanServer.getAttribute(new ObjectName("org.apache.activemq.artemis:broker=\"localhost\",component=addresses,address=\"" + this.topicWildcard + "\""), "AddressSize");
        Assert.assertTrue((String)(this.topicA + " AddressSize < 0"), (addressSizeA >= 0L ? (byte)1 : 0) != 0);
        Assert.assertTrue((String)(this.topicWildcard + " AddressSize < 0"), (addressSizeWC >= 0L ? (byte)1 : 0) != 0);
    }

    private void testNegativeAddressSizeOnWildcardAsync(int numMessages) throws Exception {
        Session sessionA = this.createSession();
        MessageProducer producerA = this.createProducer(sessionA, this.topicA);
        CountDownLatch latchA = new CountDownLatch(numMessages);
        MessageConsumer consumerA = this.createAsyncConsumer(this.topicA, latchA);
        CountDownLatch latchWC = new CountDownLatch(numMessages);
        MessageConsumer consumerWC = this.createAsyncConsumer(this.topicWildcard, latchWC);
        for (int i = 0; i < numMessages; ++i) {
            ObjectMessage message = sessionA.createObjectMessage((Serializable)Integer.valueOf(i));
            producerA.send((Message)message);
        }
        if (!latchA.await(5L, TimeUnit.SECONDS)) {
            Assert.fail((String)("Waiting to receive " + latchA.getCount() + " messages on " + this.topicA));
        }
        if (!latchWC.await(5L, TimeUnit.SECONDS)) {
            Assert.fail((String)("Waiting to receive " + latchWC.getCount() + " messages on " + this.topicWildcard));
        }
        long addressSizeA = (Long)this.mbeanServer.getAttribute(new ObjectName("org.apache.activemq.artemis:broker=\"localhost\",component=addresses,address=\"" + this.topicA + "\""), "AddressSize");
        long addressSizeWC = (Long)this.mbeanServer.getAttribute(new ObjectName("org.apache.activemq.artemis:broker=\"localhost\",component=addresses,address=\"" + this.topicWildcard + "\""), "AddressSize");
        Assert.assertTrue((String)(this.topicA + " AddressSize < 0"), (addressSizeA >= 0L ? (byte)1 : 0) != 0);
        Assert.assertTrue((String)(this.topicWildcard + " AddressSize < 0"), (addressSizeWC >= 0L ? (byte)1 : 0) != 0);
    }

    private Session createSession() throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        return session;
    }

    private MessageProducer createProducer(Session session, String topicName) throws Exception {
        Topic topic = session.createTopic(topicName);
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.setDeliveryMode(1);
        return producer;
    }

    private MessageConsumer createConsumer(String topicName) throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(topicName);
        MessageConsumer consumer = session.createConsumer((Destination)topic, null, false);
        return consumer;
    }

    private MessageConsumer createAsyncConsumer(String topicName, CountDownLatch latch) throws Exception {
        MessageConsumer consumer = this.createConsumer(topicName);
        consumer.setMessageListener(m -> {
            try {
                latch.countDown();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
        return consumer;
    }
}

