/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;

public abstract class SecurityManagementTestBase
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.setupAndStartActiveMQServer();
    }

    protected abstract ActiveMQServer setupAndStartActiveMQServer() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendManagementMessage(String user, String password, boolean expectSuccess) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        try (ClientSessionFactory sf = locator.createSessionFactory();){
            ClientSession session = null;
            session = user == null ? sf.createSession(false, true, true) : sf.createSession(user, password, false, true, true, false, 1);
            session.start();
            ClientRequestor requestor = new ClientRequestor(session, ActiveMQDefaultConfiguration.getDefaultManagementAddress());
            ClientMessage mngmntMessage = session.createMessage(false);
            ManagementHelper.putAttribute((ICoreMessage)mngmntMessage, (String)"broker", (String)"started");
            ClientMessage reply = requestor.request(mngmntMessage, 500L);
            if (expectSuccess) {
                Assert.assertNotNull((Object)reply);
                Assert.assertTrue((boolean)((Boolean)ManagementHelper.getResult((ICoreMessage)reply)));
            } else {
                Assert.assertNull((Object)reply);
            }
            requestor.close();
        }
    }
}

