/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Test;

public class JMSIndividualAckTest
extends BasicOpenWireTest {
    @Test
    public void testAckedMessageAreConsumed() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 4);
        Queue queue = (Queue)this.createDestination(session, (byte)1);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(5000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 4);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNull((Object)msg);
        session.close();
    }

    @Test
    public void testLastMessageAcked() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 4);
        Queue queue = (Queue)this.createDestination(session, (byte)1);
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage msg1 = session.createTextMessage("msg1");
        TextMessage msg2 = session.createTextMessage("msg2");
        TextMessage msg3 = session.createTextMessage("msg3");
        producer.send((Message)msg1);
        producer.send((Message)msg2);
        producer.send((Message)msg3);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 4);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        JMSIndividualAckTest.assertEquals((Object)msg1, (Object)msg);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        JMSIndividualAckTest.assertEquals((Object)msg2, (Object)msg);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNull((Object)msg);
        session.close();
    }

    @Test
    public void testUnAckedMessageAreNotConsumedOnSessionClose() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 4);
        Queue queue = (Queue)this.createDestination(session, (byte)1);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        session.close();
        session = this.connection.createSession(false, 4);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(2000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
    }
}

