/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Assert;
import org.junit.Test;

public class ReconnectFailoverTest
extends BasicOpenWireTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconnectOnFailoverWithClientID() throws Exception {
        ActiveMQConnectionFactory failoverFactory = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616)");
        try (Connection connection = failoverFactory.createConnection();){
            connection.setClientID("foo");
            Session session = connection.createSession(false, 1);
            this.server.getRemotingService().getConnections().forEach(c -> c.getTransportConnection().forceClose());
            TemporaryQueue tempQueue = session.createTemporaryQueue();
            MessageProducer producer = session.createProducer((Destination)tempQueue);
            for (int i = 0; i < 10; ++i) {
                producer.send((Message)session.createTextMessage("hello"));
            }
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)tempQueue);
            for (int i = 0; i < 10; ++i) {
                TextMessage message = (TextMessage)consumer.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)"hello", (Object)message.getText());
            }
        }
    }
}

