/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndividualAckPagingTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(IndividualAckPagingTest.class);
    protected final boolean paging;
    protected final boolean restartServerBeforeConsume;
    private static final String ADDRESS = "IndividualAckPagingTest";
    ActiveMQServer server;
    protected static final int PAGE_MAX = 10240;
    protected static final int PAGE_SIZE = 5120;

    @Parameterized.Parameters(name="paging={0}, restartServerBeforeConsume={1}")
    public static Collection getParams() {
        return Arrays.asList({true, false}, {true, true}, {false, false});
    }

    public IndividualAckPagingTest(boolean paging, boolean restartServerBeforeConsume) {
        this.paging = paging;
        this.restartServerBeforeConsume = restartServerBeforeConsume;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultConfig(0, true).setJournalSyncNonTransactional(false);
        config.setMessageExpiryScanPeriod(-1L);
        if (this.paging) {
            this.server = this.createServer(true, config, 5120, 10240L);
            this.server.getAddressSettingsRepository().clear();
            AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(5120).setMaxSizeBytes(10240L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false));
            this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        } else {
            this.server = this.createServer(true, config, 0xA00000, -1L);
            this.server.getAddressSettingsRepository().clear();
            AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(0xA00000).setMaxSizeBytes(-1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false));
            this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        }
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(ADDRESS).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testIndividualAckCore() throws Exception {
        this.testIndividualAck("CORE", 1024);
    }

    @Test
    public void testIndividualAckAMQP() throws Exception {
        this.testIndividualAck("AMQP", 1024);
    }

    public void testIndividualAck(String protocol, int bodySize) throws Exception {
        MessageConsumer consumer;
        TextMessage message;
        int i;
        jakarta.jms.Queue jmsQueue;
        Session session;
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < bodySize; ++i2) {
            buffer.append("*");
        }
        String extraBody = buffer.toString();
        Queue queue = this.server.locateQueue(ADDRESS);
        try (Connection connection = factory.createConnection();){
            session = connection.createSession(true, 0);
            jmsQueue = session.createQueue(ADDRESS);
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            for (i = 0; i < 100; ++i) {
                message = session.createTextMessage(extraBody);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            session.commit();
        }
        connection = factory.createConnection();
        var7_8 = null;
        try {
            session = connection.createSession(false, 101);
            jmsQueue = session.createQueue(ADDRESS);
            connection.start();
            consumer = session.createConsumer((Destination)jmsQueue);
            for (i = 0; i < 100; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)message);
                if (message.getIntProperty("i") != 77) continue;
                message.acknowledge();
            }
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable session2) {
            var7_8 = session2;
            throw session2;
        }
        finally {
            if (connection != null) {
                if (var7_8 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable session2) {
                        var7_8.addSuppressed(session2);
                    }
                } else {
                    connection.close();
                }
            }
        }
        if (this.restartServerBeforeConsume) {
            this.server.stop();
            this.server.start();
        }
        connection = factory.createConnection();
        var7_8 = null;
        try {
            session = connection.createSession(false, 1);
            jmsQueue = session.createQueue(ADDRESS);
            connection.start();
            consumer = session.createConsumer((Destination)jmsQueue);
            for (i = 0; i < 99; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)message);
                Assert.assertNotEquals((long)77L, (long)message.getIntProperty("i"));
            }
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var7_8 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var7_8.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }
}

