/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.impl.DuplicateIDCaches;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DuplicateCacheTest
extends StorageManagerTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(2);

    public DuplicateCacheTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testDuplicate() throws Exception {
        byte[] bytes;
        int i;
        this.createStorage();
        DuplicateIDCache cache = DuplicateIDCaches.persistent((SimpleString)new SimpleString("test"), (int)2000, (StorageManager)this.journal);
        TransactionImpl tx = new TransactionImpl(this.journal);
        for (i = 0; i < 5000; ++i) {
            bytes = RandomUtil.randomBytes();
            cache.addToCache(bytes, (Transaction)tx);
        }
        tx.commit();
        tx = new TransactionImpl(this.journal);
        for (i = 0; i < 5000; ++i) {
            bytes = RandomUtil.randomBytes();
            cache.addToCache(bytes, (Transaction)tx);
        }
        tx.commit();
        byte[] id = RandomUtil.randomBytes();
        Assert.assertFalse((boolean)cache.contains(id));
        cache.addToCache(id, null);
        Assert.assertTrue((boolean)cache.contains(id));
        cache.deleteFromCache(id);
        final CountDownLatch latch = new CountDownLatch(1);
        OperationContextImpl.getContext().executeOnCompletion(new IOCallback(){

            public void done() {
                latch.countDown();
            }

            public void onError(int errorCode, String errorMessage) {
            }
        }, true);
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
        Assert.assertFalse((boolean)cache.contains(id));
        cache.clear();
    }

    @Test
    public void testDuplicateNonPersistent() throws Exception {
        byte[] bytes;
        int i;
        this.createStorage();
        DuplicateIDCache cache = DuplicateIDCaches.inMemory((SimpleString)new SimpleString("test"), (int)2000);
        TransactionImpl tx = new TransactionImpl(this.journal);
        for (i = 0; i < 5000; ++i) {
            bytes = RandomUtil.randomBytes();
            cache.addToCache(bytes, (Transaction)tx);
        }
        tx.commit();
        for (i = 0; i < 5000; ++i) {
            bytes = RandomUtil.randomBytes();
            cache.addToCache(bytes, null);
        }
        cache.clear();
    }
}

