/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.remoting;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DirectDeliverTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServerLocator nettyLocator;
    private ServerLocator inVMLocator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Boolean> nettyParams = new HashMap<String, Boolean>();
        nettyParams.put("directDeliver", true);
        TransportConfiguration nettyTransportConfiguration = new TransportConfiguration(NettyAcceptorFactory.class.getName(), nettyParams);
        HashMap<String, Boolean> inVMParams = new HashMap<String, Boolean>();
        inVMParams.put("directDeliver", true);
        TransportConfiguration inVMTransportConfiguration = new TransportConfiguration(InVMAcceptorFactory.class.getName(), inVMParams);
        ConfigurationImpl config = this.createBasicConfig();
        config.addAcceptorConfiguration(nettyTransportConfiguration);
        config.addAcceptorConfiguration(inVMTransportConfiguration);
        this.server = this.createServer(false, (Configuration)config);
        this.server.start();
        this.nettyLocator = this.createNettyNonHALocator();
        this.addServerLocator(this.nettyLocator);
        this.inVMLocator = this.createInVMLocator(0);
        this.addServerLocator(this.inVMLocator);
    }

    @Test
    public void testDirectDeliverNetty() throws Exception {
        this.testDirectDeliver(this.nettyLocator);
    }

    @Test
    public void testDirectDeliverInVM() throws Exception {
        this.testDirectDeliver(this.inVMLocator);
    }

    private void testDirectDeliver(ServerLocator serverLocator) throws Exception {
        int i;
        ClientMessage msg;
        int i2;
        String foo = "foo";
        ClientSessionFactory sf = this.createSessionFactory(serverLocator);
        ClientSession session = sf.createSession();
        session.createQueue(new QueueConfiguration("foo").setRoutingType(RoutingType.ANYCAST));
        Binding binding = this.server.getPostOffice().getBinding(new SimpleString("foo"));
        Queue queue = (Queue)binding.getBindable();
        Assert.assertFalse((boolean)queue.isDirectDeliver());
        ClientProducer prod = session.createProducer("foo");
        ClientConsumer cons = session.createConsumer("foo");
        int numMessages = 100;
        for (i2 = 0; i2 < 100; ++i2) {
            msg = session.createMessage(true);
            prod.send((Message)msg);
        }
        queue.flushExecutor();
        DirectDeliverTest.assertFalse((boolean)queue.isDirectDeliver());
        session.start();
        for (i2 = 0; i2 < 100; ++i2) {
            msg = cons.receive(10000L);
            DirectDeliverTest.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        Thread.sleep(1500L);
        ClientMessage msg2 = session.createMessage(true);
        prod.send((Message)msg2);
        queue.flushExecutor();
        DirectDeliverTest.assertTrue((boolean)queue.isDirectDeliver());
        for (i = 0; i < 100; ++i) {
            msg2 = session.createMessage(true);
            prod.send((Message)msg2);
        }
        for (i = 0; i < 101; ++i) {
            msg2 = cons.receive(10000L);
            DirectDeliverTest.assertNotNull((Object)msg2);
            msg2.acknowledge();
        }
        DirectDeliverTest.assertTrue((boolean)queue.isDirectDeliver());
        session.stop();
        for (i = 0; i < 100; ++i) {
            msg2 = session.createMessage(true);
            prod.send((Message)msg2);
        }
        DirectDeliverTest.assertFalse((boolean)queue.isDirectDeliver());
    }
}

