/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.rest.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.tests.integration.rest.util.QueueRestMessageContext;
import org.apache.activemq.artemis.tests.integration.rest.util.RestMessageContext;
import org.apache.activemq.artemis.tests.integration.rest.util.TopicRestMessageContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class RestAMQConnection
implements Closeable {
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    private String targetUri;
    private List<RestMessageContext> contexts = new ArrayList<RestMessageContext>();

    public RestAMQConnection(String targetUri) {
        this.targetUri = targetUri;
    }

    public QueueRestMessageContext createQueueContext(String queue) throws Exception {
        QueueRestMessageContext ctx = new QueueRestMessageContext(this, queue);
        this.contexts.add(ctx);
        return ctx;
    }

    public TopicRestMessageContext createTopicContext(String topic) throws Exception {
        TopicRestMessageContext ctx = new TopicRestMessageContext(this, topic, false);
        this.contexts.add(ctx);
        return ctx;
    }

    @Override
    public void close() throws IOException {
        for (RestMessageContext ctx : this.contexts) {
            ctx.close();
        }
        this.httpClient.close();
    }

    private String getFullLink(String link) {
        if (link.startsWith("http:")) {
            return link;
        }
        return this.targetUri + link;
    }

    public CloseableHttpResponse request(String destLink) throws IOException {
        String fullLink = this.getFullLink(destLink);
        HttpGet request = new HttpGet(fullLink);
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)request);
        return resp;
    }

    public CloseableHttpResponse post(String uri, String contentType, String body) throws IOException {
        String fullLink = this.getFullLink(uri);
        HttpPost post = new HttpPost(fullLink);
        StringEntity entity = new StringEntity(body, ContentType.create((String)contentType));
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return resp;
    }

    public CloseableHttpResponse post(String uri) throws IOException {
        String fullLink = this.getFullLink(uri);
        HttpPost post = new HttpPost(fullLink);
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        return resp;
    }

    public void delete(String uri) throws IOException {
        String consumerUri = this.getFullLink(uri);
        HttpDelete delete = new HttpDelete(consumerUri);
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)delete);
    }

    public String getTargetUri() {
        return this.targetUri;
    }
}

