/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;

public abstract class AbstractClientStompFrame
implements ClientStompFrame {
    protected static final Set<String> validCommands = new HashSet<String>();
    protected String command;
    protected List<Header> headers = new ArrayList<Header>();
    protected Set<String> headerKeys = new HashSet<String>();
    protected String body;
    protected String EOL = "\n";

    public AbstractClientStompFrame(String command) {
        this(command, true);
    }

    public AbstractClientStompFrame(String command, boolean validate) {
        if (validate && !this.validate(command)) {
            throw new IllegalArgumentException("Invalid command " + command);
        }
        this.command = command;
    }

    public boolean validate(String command) {
        return validCommands.contains(command);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Frame: <" + this.command + ">\n");
        for (Header h : this.headers) {
            sb.append(h.key + ":" + h.val + "\n");
        }
        sb.append("\n");
        sb.append("<body>" + this.body + "<body>");
        return sb.toString();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.toByteBufferInternal(null);
    }

    @Override
    public ByteBuffer toByteBufferWithExtra(String str) {
        return this.toByteBufferInternal(str);
    }

    @Override
    public ByteBuf toNettyByteBuf() {
        return Unpooled.copiedBuffer((ByteBuffer)this.toByteBuffer());
    }

    @Override
    public ByteBuf toNettyByteBufWithExtras(String str) {
        return Unpooled.copiedBuffer((ByteBuffer)this.toByteBufferWithExtra(str));
    }

    public ByteBuffer toByteBufferInternal(String str) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.command + this.EOL);
        int n = this.headers.size();
        for (int i = 0; i < n; ++i) {
            sb.append(this.headers.get((int)i).key + ":" + this.headers.get((int)i).val + this.EOL);
        }
        sb.append(this.EOL);
        if (this.body != null) {
            sb.append(this.body);
        }
        sb.append('\u0000');
        if (str != null) {
            sb.append(str);
        }
        String data = sb.toString();
        byte[] byteValue = data.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocateDirect(byteValue.length);
        buffer.put(byteValue);
        buffer.rewind();
        return buffer;
    }

    @Override
    public boolean needsReply() {
        return "CONNECT".equals(this.command) || this.headerKeys.contains("receipt");
    }

    @Override
    public ClientStompFrame setCommand(String command) {
        this.command = command;
        return this;
    }

    @Override
    public ClientStompFrame addHeader(String key, String val) {
        this.headers.add(new Header(key, val));
        this.headerKeys.add(key);
        return this;
    }

    @Override
    public ClientStompFrame setBody(String body) {
        this.body = body;
        return this;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getHeader(String header) {
        if (this.headerKeys.contains(header)) {
            for (Header h : this.headers) {
                if (!h.key.equals(header)) continue;
                return h.val;
            }
        }
        return null;
    }

    static {
        validCommands.add("CONNECT");
        validCommands.add("CONNECTED");
        validCommands.add("SEND");
        validCommands.add("RECEIPT");
        validCommands.add("SUBSCRIBE");
        validCommands.add("UNSUBSCRIBE");
        validCommands.add("MESSAGE");
        validCommands.add("BEGIN");
        validCommands.add("COMMIT");
        validCommands.add("ABORT");
        validCommands.add("ACK");
        validCommands.add("DISCONNECT");
        validCommands.add("ERROR");
    }

    private class Header {
        public String key;
        public String val;

        private Header(String key, String val) {
            this.key = key;
            this.val = val;
        }
    }
}

