/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.nio.ByteBuffer;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;

public abstract class FileFactoryTestBase
extends ActiveMQTestBase {
    protected SequentialFileFactory factory;

    protected abstract SequentialFileFactory createFactory();

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.factory = this.createFactory();
    }

    protected void checkFill(SequentialFile file, int size) throws Exception {
        file.fill(size);
        file.close();
        file.open();
        file.position(0L);
        ByteBuffer bb = ByteBuffer.allocateDirect(size);
        int bytesRead = file.read(bb);
        Assert.assertEquals((long)size, (long)bytesRead);
        bb.rewind();
        byte[] bytes = new byte[size];
        bb.get(bytes);
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)0L, (long)bytes[i]);
        }
    }
}

