/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.message.impl;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class MessageImplTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(MessageImplTest.class);

    @Test
    public void getSetAttributes() {
        for (int j = 0; j < 10; ++j) {
            ClientMessageImpl message1;
            byte[] bytes = new byte[1000];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = RandomUtil.randomByte();
            }
            byte type = RandomUtil.randomByte();
            boolean durable = RandomUtil.randomBoolean();
            long expiration = RandomUtil.randomLong();
            long timestamp = RandomUtil.randomLong();
            byte priority = RandomUtil.randomByte();
            ClientMessageImpl message = message1 = new ClientMessageImpl(type, durable, expiration, timestamp, priority, 100);
            Assert.assertEquals((long)type, (long)message.getType());
            Assert.assertEquals((Object)durable, (Object)message.isDurable());
            Assert.assertEquals((long)expiration, (long)message.getExpiration());
            Assert.assertEquals((long)timestamp, (long)message.getTimestamp());
            Assert.assertEquals((long)priority, (long)message.getPriority());
            SimpleString destination = new SimpleString(RandomUtil.randomString());
            boolean durable2 = RandomUtil.randomBoolean();
            long expiration2 = RandomUtil.randomLong();
            long timestamp2 = RandomUtil.randomLong();
            byte priority2 = RandomUtil.randomByte();
            message.setAddress(destination);
            Assert.assertEquals((Object)destination, (Object)message.getAddressSimpleString());
            message.setDurable(durable2);
            Assert.assertEquals((Object)durable2, (Object)message.isDurable());
            message.setExpiration(expiration2);
            Assert.assertEquals((long)expiration2, (long)message.getExpiration());
            message.setTimestamp(timestamp2);
            Assert.assertEquals((long)timestamp2, (long)message.getTimestamp());
            message.setPriority(priority2);
            Assert.assertEquals((long)priority2, (long)message.getPriority());
        }
    }

    @Test
    public void testExpired() {
        ClientMessageImpl message = new ClientMessageImpl();
        Assert.assertEquals((long)0L, (long)message.getExpiration());
        Assert.assertFalse((boolean)message.isExpired());
        message.setExpiration(System.currentTimeMillis() + 1000L);
        Assert.assertFalse((boolean)message.isExpired());
        message.setExpiration(System.currentTimeMillis() - 1L);
        Assert.assertTrue((boolean)message.isExpired());
        message.setExpiration(System.currentTimeMillis() - 1000L);
        Assert.assertTrue((boolean)message.isExpired());
        message.setExpiration(0L);
        Assert.assertFalse((boolean)message.isExpired());
    }

    @Test
    public void testProperties() {
        for (int j = 0; j < 10; ++j) {
            ClientMessageImpl msg = new ClientMessageImpl();
            SimpleString prop1 = new SimpleString("prop1");
            boolean val1 = RandomUtil.randomBoolean();
            msg.putBooleanProperty(prop1, val1);
            SimpleString prop2 = new SimpleString("prop2");
            byte val2 = RandomUtil.randomByte();
            msg.putByteProperty(prop2, val2);
            SimpleString prop3 = new SimpleString("prop3");
            byte[] val3 = RandomUtil.randomBytes();
            msg.putBytesProperty(prop3, val3);
            SimpleString prop4 = new SimpleString("prop4");
            double val4 = RandomUtil.randomDouble();
            msg.putDoubleProperty(prop4, val4);
            SimpleString prop5 = new SimpleString("prop5");
            float val5 = RandomUtil.randomFloat();
            msg.putFloatProperty(prop5, val5);
            SimpleString prop6 = new SimpleString("prop6");
            int val6 = RandomUtil.randomInt();
            msg.putIntProperty(prop6, val6);
            SimpleString prop7 = new SimpleString("prop7");
            long val7 = RandomUtil.randomLong();
            msg.putLongProperty(prop7, val7);
            SimpleString prop8 = new SimpleString("prop8");
            short val8 = RandomUtil.randomShort();
            msg.putShortProperty(prop8, val8);
            SimpleString prop9 = new SimpleString("prop9");
            SimpleString val9 = new SimpleString(RandomUtil.randomString());
            msg.putStringProperty(prop9, val9);
            Assert.assertEquals((long)9L, (long)msg.getPropertyNames().size());
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop1));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop2));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop3));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop4));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop5));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop6));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop7));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop8));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop9));
            Assert.assertTrue((boolean)msg.containsProperty(prop1));
            Assert.assertTrue((boolean)msg.containsProperty(prop2));
            Assert.assertTrue((boolean)msg.containsProperty(prop3));
            Assert.assertTrue((boolean)msg.containsProperty(prop4));
            Assert.assertTrue((boolean)msg.containsProperty(prop5));
            Assert.assertTrue((boolean)msg.containsProperty(prop6));
            Assert.assertTrue((boolean)msg.containsProperty(prop7));
            Assert.assertTrue((boolean)msg.containsProperty(prop8));
            Assert.assertTrue((boolean)msg.containsProperty(prop9));
            Assert.assertEquals((Object)val1, (Object)msg.getObjectProperty(prop1));
            Assert.assertEquals((Object)val2, (Object)msg.getObjectProperty(prop2));
            Assert.assertEquals((Object)val3, (Object)msg.getObjectProperty(prop3));
            Assert.assertEquals((Object)val4, (Object)msg.getObjectProperty(prop4));
            Assert.assertEquals((Object)Float.valueOf(val5), (Object)msg.getObjectProperty(prop5));
            Assert.assertEquals((Object)val6, (Object)msg.getObjectProperty(prop6));
            Assert.assertEquals((Object)val7, (Object)msg.getObjectProperty(prop7));
            Assert.assertEquals((Object)val8, (Object)msg.getObjectProperty(prop8));
            Assert.assertEquals((Object)val9, (Object)msg.getObjectProperty(prop9));
            SimpleString val10 = new SimpleString(RandomUtil.randomString());
            msg.putStringProperty(prop9, val10);
            Assert.assertEquals((Object)val10, (Object)msg.getObjectProperty(prop9));
            int val11 = RandomUtil.randomInt();
            msg.putIntProperty(prop9, val11);
            Assert.assertEquals((Object)val11, (Object)msg.getObjectProperty(prop9));
            msg.removeProperty(prop1);
            Assert.assertEquals((long)8L, (long)msg.getPropertyNames().size());
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop2));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop3));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop4));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop5));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop6));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop7));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop8));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop9));
            msg.removeProperty(prop2);
            Assert.assertEquals((long)7L, (long)msg.getPropertyNames().size());
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop3));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop4));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop5));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop6));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop7));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop8));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop9));
            msg.removeProperty(prop9);
            Assert.assertEquals((long)6L, (long)msg.getPropertyNames().size());
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop3));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop4));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop5));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop6));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop7));
            Assert.assertTrue((boolean)msg.getPropertyNames().contains(prop8));
            msg.removeProperty(prop3);
            msg.removeProperty(prop4);
            msg.removeProperty(prop5);
            msg.removeProperty(prop6);
            msg.removeProperty(prop7);
            msg.removeProperty(prop8);
            Assert.assertEquals((long)0L, (long)msg.getPropertyNames().size());
        }
    }

    @Test
    public void testMessageCopyIssue() throws Exception {
        for (long i = 0L; i < 300L; ++i) {
            if (i % 10L == 0L) {
                log.debug((Object)("#test " + i));
            }
            this.internalMessageCopy();
        }
    }

    @Test
    public void testMessageCopyHeadersAndProperties() {
        CoreMessage msg1 = new CoreMessage(123L, 18);
        SimpleString address = new SimpleString("address");
        msg1.setAddress(address);
        UUID uid = UUIDGenerator.getInstance().generateUUID();
        msg1.setUserID(uid);
        byte type = 3;
        msg1.setType(type);
        boolean durable = true;
        msg1.setDurable(durable);
        long expiration = System.currentTimeMillis();
        msg1.setExpiration(expiration);
        long timestamp = System.currentTimeMillis();
        msg1.setTimestamp(timestamp);
        byte priority = 9;
        msg1.setPriority(priority);
        String routeTo = "_HQ_ROUTE_TOsomething";
        String value = "Byte array substitute";
        msg1.putStringProperty(routeTo, value);
        CoreMessage msg2 = new CoreMessage(456L, 18);
        msg2.moveHeadersAndProperties((Message)msg1);
        MessageImplTest.assertEquals((Object)msg1.getAddress(), (Object)msg2.getAddress());
        MessageImplTest.assertEquals((Object)msg1.getUserID(), (Object)msg2.getUserID());
        MessageImplTest.assertEquals((long)msg1.getType(), (long)msg2.getType());
        MessageImplTest.assertEquals((Object)msg1.isDurable(), (Object)msg2.isDurable());
        MessageImplTest.assertEquals((long)msg1.getExpiration(), (long)msg2.getExpiration());
        MessageImplTest.assertEquals((long)msg1.getTimestamp(), (long)msg2.getTimestamp());
        MessageImplTest.assertEquals((long)msg1.getPriority(), (long)msg2.getPriority());
        MessageImplTest.assertEquals((Object)value, (Object)msg2.getStringProperty(routeTo));
        msg2.setAddress(address.concat("new"));
        msg2.setUserID(UUIDGenerator.getInstance().generateUUID());
        type = (byte)(type - 1);
        msg2.setType(type);
        msg2.setDurable(!durable);
        msg2.setExpiration(expiration + 1000L);
        msg2.setTimestamp(timestamp + 1000L);
        priority = (byte)(priority - 1);
        msg2.setPriority(priority);
        msg2.putStringProperty(routeTo, value + "new");
        MessageImplTest.assertNotEquals((Object)msg1.getAddress(), (Object)msg2.getAddress());
        MessageImplTest.assertNotEquals((Object)msg1.getUserID(), (Object)msg2.getUserID());
        MessageImplTest.assertNotEquals((long)msg1.getType(), (long)msg2.getType());
        MessageImplTest.assertNotEquals((Object)msg1.isDurable(), (Object)msg2.isDurable());
        MessageImplTest.assertNotEquals((long)msg1.getExpiration(), (long)msg2.getExpiration());
        MessageImplTest.assertNotEquals((long)msg1.getTimestamp(), (long)msg2.getTimestamp());
        MessageImplTest.assertNotEquals((long)msg1.getPriority(), (long)msg2.getPriority());
        MessageImplTest.assertNotEquals((Object)msg1.getStringProperty(routeTo), (Object)msg2.getStringProperty(routeTo));
    }

    private void internalMessageCopy() throws Exception {
        int i;
        long RUNS = 2L;
        final CoreMessage msg = new CoreMessage(123L, 18);
        msg.setMessageID(RandomUtil.randomLong());
        msg.setAddress(new SimpleString("Batatantkashf aksjfh aksfjh askfdjh askjfh "));
        final AtomicInteger errors = new AtomicInteger(0);
        int T1_number = 10;
        int T2_number = 10;
        final CountDownLatch latchAlign = new CountDownLatch(T1_number + T2_number);
        final CountDownLatch latchReady = new CountDownLatch(1);
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < 500; ++i) {
            buffer.append(" ");
        }
        String bigString = buffer.toString();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (i = 0; i < T1_number; ++i) {
            class T1
            extends Thread {
                T1() {
                }

                @Override
                public void run() {
                    latchAlign.countDown();
                    try {
                        latchReady.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int i = 0;
                    while ((long)i < 2L) {
                        try {
                            Message message = msg.copy();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            errors.incrementAndGet();
                        }
                        ++i;
                    }
                }
            }
            Thread t = new T1();
            threads.add(t);
            t.start();
        }
        for (i = 0; i < T2_number; ++i) {
            class T2
            extends Thread {
                T2() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    latchAlign.countDown();
                    try {
                        latchReady.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int i = 0;
                    while ((long)i < 2L) {
                        ActiveMQBuffer buf = null;
                        try {
                            SessionSendMessage ssm = new SessionSendMessage(msg);
                            buf = ssm.encode(null);
                            MessageImplTest.this.simulateRead(buf);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            errors.incrementAndGet();
                        }
                        finally {
                            if (buf != null) {
                                buf.release();
                            }
                        }
                        ++i;
                    }
                }
            }
            T2 t2 = new T2();
            threads.add(t2);
            t2.start();
        }
        latchAlign.await();
        latchReady.countDown();
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertEquals((long)0L, (long)errors.get());
    }

    private void simulateRead(ActiveMQBuffer buf) {
        buf.setIndex(buf.capacity() / 2, buf.capacity() / 2);
        buf.writeBytes(new byte[1024]);
    }

    @Test
    public void testCloseCallBuffer() throws Exception {
        SimpleString ADDRESS = new SimpleString("SimpleAddress");
        int messageSize = 1048512;
        int journalsize = 0xA00000;
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setMinLargeMessageSize(0x100000);
        ClientSession session = null;
        ConfigurationImpl config = (ConfigurationImpl)this.createDefaultConfig(false);
        config.setJournalFileSize(0xA00000).setJournalBufferSize_AIO(0x100000).setJournalBufferSize_NIO(0x100000);
        ActiveMQServer server = this.createServer(true, (Configuration)config);
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        session = this.addClientSession(sf.createSession(false, false, 0));
        session.createQueue(new QueueConfiguration(ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        ClientMessage clientFile = session.createMessage(true);
        for (int i = 0; i < 1048512; ++i) {
            clientFile.getBodyBuffer().writeByte(MessageImplTest.getSamplebyte((long)i));
        }
        producer.send((Message)clientFile);
        session.commit();
        session.start();
        ClientMessage msg1 = consumer.receive(1000L);
        Wait.assertTrue(() -> ((ActiveMQServer)server).isActive());
        MessageImplTest.assertNotNull((Object)msg1);
    }
}

