/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQChannelHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NettyConnectorTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ExecutorService executorService;
    private ClientConnectionLifeCycleListener listener = new ClientConnectionLifeCycleListener(){

        public void connectionException(Object connectionID, ActiveMQException me) {
        }

        public void connectionDestroyed(Object connectionID) {
        }

        public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    };

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("sslProvider", "OPENSSL");
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, "nettySSL"));
        this.server = this.createServer(false, (Configuration)config);
        this.server.start();
        this.waitForServerToStart(this.server);
    }

    public void tearDown() throws Exception {
        this.executorService.shutdown();
        super.tearDown();
    }

    @Test
    public void testStartStop() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        HashMap params = new HashMap();
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testNullParams() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        HashMap params = new HashMap();
        try {
            new NettyConnector(params, null, (BaseConnectionLifeCycleListener)this.listener, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
            Assert.fail((String)"Should throw Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new NettyConnector(params, handler, null, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
            Assert.fail((String)"Should throw Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testJavaSystemProperty() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        System.setProperty("javax.net.ssl.keyStore", "client-keystore.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", "securepass");
        System.setProperty("javax.net.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "securepass");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        NettyConnectorTest.assertNotNull((Object)c);
        c.close();
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testOverridesJavaSystemPropertyFail() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        System.setProperty("javax.net.ssl.keyStore", "bad path");
        System.setProperty("javax.net.ssl.keyStorePassword", "bad password");
        System.setProperty("javax.net.ssl.trustStore", "bad path");
        System.setProperty("javax.net.ssl.trustStorePassword", "bad password");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "client-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "server-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        NettyConnectorTest.assertNull((Object)c);
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testOverridesJavaSystemProperty() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        System.setProperty("javax.net.ssl.keyStore", "client-keystore.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", "securepass");
        System.setProperty("javax.net.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "securepass");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "bad path");
        params.put("keyStorePassword", "bad password");
        params.put("trustStorePath", "bad path");
        params.put("trustStorePassword", "bad password");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        NettyConnectorTest.assertNotNull((Object)c);
        c.close();
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testOverridesJavaSystemPropertyForceSSLParameters() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        System.setProperty("javax.net.ssl.keyStore", "bad path");
        System.setProperty("javax.net.ssl.keyStorePassword", "bad password");
        System.setProperty("javax.net.ssl.trustStore", "bad path");
        System.setProperty("javax.net.ssl.trustStorePassword", "bad password");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("forceSSLParameters", true);
        params.put("keyStorePath", "client-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "server-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        NettyConnectorTest.assertNotNull((Object)c);
        c.close();
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testOverridesJavaSystemPropertyForceSSLParameters2() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        System.setProperty("javax.net.ssl.keyStore", "client-keystore.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", "securepass");
        System.setProperty("javax.net.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "securepass");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        params.put("forceSSLParameters", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Object c = null;
        try {
            connector.createConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        NettyConnectorTest.assertNull(c);
    }

    @Test
    public void tesActiveMQSystemProperties() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", "securepass");
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", "securepass");
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        NettyConnectorTest.assertNotNull((Object)c);
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testActiveMQOverridesSystemProperty() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", "securepass");
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", "securepass");
        System.setProperty("javax.net.ssl.keyStore", "bad path");
        System.setProperty("javax.net.ssl.keyStorePassword", "bad password");
        System.setProperty("javax.net.ssl.trustStore", "bad path");
        System.setProperty("javax.net.ssl.trustStorePassword", "bad password");
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        NettyConnectorTest.assertNotNull((Object)c);
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testBadCipherSuite() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("enabledCipherSuites", "myBadCipherSuite");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Assert.assertNull((Object)connector.createConnection());
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testBadProtocol() throws Exception {
        BufferHandler handler = new BufferHandler(){

            public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            }
        };
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("enabledProtocols", "myBadProtocol");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory()));
        connector.start();
        Assert.assertTrue((boolean)connector.isStarted());
        Assert.assertNull((Object)connector.createConnection());
        connector.close();
        Assert.assertFalse((boolean)connector.isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelHandlerRemovedWhileCreatingConnection() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap params = new HashMap();
        ExecutorService closeExecutor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        ExecutorService threadPool = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        try {
            NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)closeExecutor, (Executor)threadPool, scheduledThreadPool);
            connector.start();
            Connection connection = connector.createConnection(future -> {
                future.awaitUninterruptibly();
                Assert.assertTrue((boolean)future.isSuccess());
                ChannelPipeline pipeline = future.channel().pipeline();
                ActiveMQChannelHandler activeMQChannelHandler = (ActiveMQChannelHandler)pipeline.get(ActiveMQChannelHandler.class);
                Assert.assertNotNull((Object)activeMQChannelHandler);
                pipeline.remove((ChannelHandler)activeMQChannelHandler);
                Assert.assertNull((Object)pipeline.get(ActiveMQChannelHandler.class));
            });
            Assert.assertNull((Object)connection);
            connector.close();
        }
        finally {
            closeExecutor.shutdownNow();
            threadPool.shutdownNow();
            scheduledThreadPool.shutdownNow();
        }
    }
}

