/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.logging;

import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AssertionLoggerTest {
    @Before
    public void prepare() {
        AssertionLoggerHandler.startCapture((boolean)true);
    }

    @After
    public void cleanup() {
        AssertionLoggerHandler.stopCapture();
    }

    @Test
    public void testHandlingOnAMQP() throws Exception {
        this.validateLogging(ActiveMQProtonRemotingConnection.class);
    }

    @Test
    public void testHandlingOnClientCore() throws Exception {
        this.validateLogging(ServerLocatorImpl.class);
    }

    @Test
    public void testInfoAMQP() throws Exception {
        ActiveMQAMQPProtocolLogger.LOGGER.retryConnection("test", "test", 1, 1);
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ111002"}));
    }

    private void validateLogging(Class clazz) {
        int i;
        String randomLogging = RandomUtil.randomString();
        Logger logging = Logger.getLogger((Class)clazz);
        logging.warn((Object)randomLogging);
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{randomLogging}));
        AssertionLoggerHandler.clear();
        for (i = 0; i < 10; ++i) {
            logging.warn((Object)randomLogging);
        }
        Assert.assertEquals((long)10L, (long)AssertionLoggerHandler.countText((String[])new String[]{randomLogging}));
        AssertionLoggerHandler.clear();
        for (i = 0; i < 10; ++i) {
            logging.info((Object)randomLogging);
        }
        Assert.assertEquals((long)10L, (long)AssertionLoggerHandler.countText((String[])new String[]{randomLogging}));
    }
}

