/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;

public final class ReplicatedBackupUtils {
    public static final String LIVE_NODE_NAME = "amqLIVE";
    public static final String BACKUP_NODE_NAME = "amqBackup";

    private ReplicatedBackupUtils() {
    }

    public static void configureReplicationPair(Configuration backupConfig, TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, Configuration liveConfig, TransportConfiguration liveConnector, TransportConfiguration liveAcceptor) {
        if (backupAcceptor != null) {
            backupConfig.clearAcceptorConfigurations().addAcceptorConfiguration(backupAcceptor);
        }
        if (liveAcceptor != null) {
            liveConfig.clearAcceptorConfigurations().addAcceptorConfiguration(liveAcceptor);
        }
        backupConfig.addConnectorConfiguration(BACKUP_NODE_NAME, backupConnector).addConnectorConfiguration(LIVE_NODE_NAME, liveConnector).addClusterConfiguration(ActiveMQTestBase.basicClusterConnectionConfig((String)BACKUP_NODE_NAME, (String[])new String[]{LIVE_NODE_NAME})).setHAPolicyConfiguration((HAPolicyConfiguration)new ReplicaPolicyConfiguration());
        liveConfig.setName(LIVE_NODE_NAME).addConnectorConfiguration(LIVE_NODE_NAME, liveConnector).addConnectorConfiguration(BACKUP_NODE_NAME, backupConnector).setSecurityEnabled(false).addClusterConfiguration(ActiveMQTestBase.basicClusterConnectionConfig((String)LIVE_NODE_NAME, (String[])new String[]{BACKUP_NODE_NAME})).setHAPolicyConfiguration((HAPolicyConfiguration)new ReplicatedPolicyConfiguration());
    }

    public static void configurePluggableQuorumReplicationPair(Configuration backupConfig, TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, Configuration liveConfig, TransportConfiguration liveConnector, TransportConfiguration liveAcceptor, DistributedPrimitiveManagerConfiguration primaryManagerConfiguration, DistributedPrimitiveManagerConfiguration backupManagerConfiguration) {
        if (backupAcceptor != null) {
            backupConfig.clearAcceptorConfigurations().addAcceptorConfiguration(backupAcceptor);
        }
        if (liveAcceptor != null) {
            liveConfig.clearAcceptorConfigurations().addAcceptorConfiguration(liveAcceptor);
        }
        backupConfig.addConnectorConfiguration(BACKUP_NODE_NAME, backupConnector).addConnectorConfiguration(LIVE_NODE_NAME, liveConnector).addClusterConfiguration(ActiveMQTestBase.basicClusterConnectionConfig((String)BACKUP_NODE_NAME, (String[])new String[]{LIVE_NODE_NAME})).setHAPolicyConfiguration((HAPolicyConfiguration)ReplicationBackupPolicyConfiguration.withDefault().setDistributedManagerConfiguration(backupManagerConfiguration));
        liveConfig.setName(LIVE_NODE_NAME).addConnectorConfiguration(LIVE_NODE_NAME, liveConnector).addConnectorConfiguration(BACKUP_NODE_NAME, backupConnector).setSecurityEnabled(false).addClusterConfiguration(ActiveMQTestBase.basicClusterConnectionConfig((String)LIVE_NODE_NAME, (String[])new String[]{BACKUP_NODE_NAME})).setHAPolicyConfiguration((HAPolicyConfiguration)ReplicationPrimaryPolicyConfiguration.withDefault().setDistributedManagerConfiguration(primaryManagerConfiguration));
    }
}

