/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.test.oauth2;

import android.support.test.runner.AndroidJUnit4;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.authorization.test.MainActivity;
import org.jboss.aerogear.android.authorization.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.store.Store;
import org.jboss.aerogear.android.store.sql.SQLStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=AndroidJUnit4.class)
public class AuthzServiceTest
extends PatchedActivityInstrumentationTestCase {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    private OAuth2AuthzService service;
    private Store mockStore;
    private OAuth2AuthzSession account;
    private URL baseUrl;
    private HttpProvider mockProvider;

    public AuthzServiceTest() {
        super(MainActivity.class);
    }

    @Before
    public void setUp() throws Exception {
        this.mockStore = (Store)Mockito.mock(SQLStore.class);
        this.mockProvider = (HttpProvider)Mockito.mock(HttpProvider.class);
        this.service = new OAuth2AuthzService(){

            protected HttpProvider getHttpProvider(URL url) {
                return AuthzServiceTest.this.mockProvider;
            }
        };
        MainActivity.UnitTestUtils.setPrivateField(this.service, "sessionStore", this.mockStore);
        this.account = new OAuth2AuthzSession();
        this.account.setAccessToken("testToken");
        this.account.setAccountId("testAccountId");
        this.account.setAuthorizationCode(null);
        this.account.setClientId("testClientId");
        this.account.setRefreshToken("testRefreshToken");
        this.baseUrl = new URL("http://example.com");
    }

    @Test
    public void testFetchTokenReturnsNullForNoAccount() throws OAuth2AuthorizationException {
        Assert.assertEquals(null, (Object)this.service.fetchAccessToken("testAccount", new OAuth2Properties(null, null)));
    }

    @Test
    public void testFetchTokenForFreshAccount() throws OAuth2AuthorizationException {
        this.account.setExpires_on(this.hourFromNow());
        Mockito.when((Object)this.mockStore.read((Serializable)Matchers.eq((Object)"testAccountId"))).thenReturn((Object)this.account);
        Assert.assertEquals((Object)"testToken", (Object)this.service.fetchAccessToken("testAccountId", new OAuth2Properties(null, null)));
    }

    @Test
    public void testErrorJsonMessage() {
        this.account.setExpires_on(this.hourAgo());
        Mockito.when((Object)this.mockStore.read((Serializable)Matchers.eq((Object)"testAccountId"))).thenReturn((Object)this.account);
        Mockito.when((Object)this.mockProvider.post((byte[])Matchers.any())).thenThrow(new Throwable[]{new HttpException("{\"error\":{\"message\":\"this is a message\"}}".getBytes(), 400)});
        try {
            this.service.fetchAccessToken("testAccountId", new OAuth2Properties(this.baseUrl, null));
        }
        catch (OAuth2AuthorizationException exception) {
            Assert.assertEquals((Object)"{\"message\":\"this is a message\"}", (Object)exception.error);
            return;
        }
        Assert.fail((String)"Exception not thrown");
    }

    @Test
    public void testErrorStringMessage() {
        this.account.setExpires_on(this.hourAgo());
        Mockito.when((Object)this.mockStore.read((Serializable)Matchers.eq((Object)"testAccountId"))).thenReturn((Object)this.account);
        Mockito.when((Object)this.mockProvider.post((byte[])Matchers.any())).thenThrow(new Throwable[]{new HttpException("{\"error\":\"this is a message\"}".getBytes(), 400)});
        try {
            this.service.fetchAccessToken("testAccountId", new OAuth2Properties(this.baseUrl, null));
        }
        catch (OAuth2AuthorizationException exception) {
            Assert.assertEquals((Object)"this is a message", (Object)exception.error);
            return;
        }
        Assert.fail((String)"Exception not thrown");
    }

    @Test
    public void testRefreshToken() throws OAuth2AuthorizationException {
        this.account.setExpires_on(this.hourAgo());
        Mockito.when((Object)this.mockStore.read((Serializable)Matchers.eq((Object)"testAccountId"))).thenReturn((Object)this.account);
        Mockito.when((Object)this.mockProvider.post((byte[])Matchers.any())).thenAnswer((Answer)new Answer<HeaderAndBody>(){

            public HeaderAndBody answer(InvocationOnMock invocation) throws Throwable {
                JsonObject object = new JsonObject();
                object.addProperty("access_token", "testRefreshedAccessToken");
                object.addProperty("expires_in", (Number)3600);
                object.addProperty("refresh_token", "testRefreshToken");
                return new HeaderAndBody(object.toString().getBytes(), new HashMap());
            }
        });
        Assert.assertEquals((Object)"testRefreshedAccessToken", (Object)this.service.fetchAccessToken("testAccountId", new OAuth2Properties(this.baseUrl, null)));
    }

    private long hourFromNow() {
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.set(10, hourFromNow.get(10) + 1);
        return hourFromNow.getTimeInMillis();
    }

    private long hourAgo() {
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.set(10, hourFromNow.get(10) - 1);
        return hourFromNow.getTimeInMillis();
    }
}

