/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz.oauth2;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Date;
import org.jboss.aerogear.android.RecordId;

public class OAuth2AuthzSession
implements Parcelable {
    @RecordId
    private String accountId = "";
    private String clientId = "";
    private String accessToken = "";
    private String authorizationCode = "";
    private String refreshToken = "";
    private long expires_on = 0L;
    public static final Parcelable.Creator<OAuth2AuthzSession> CREATOR = new Parcelable.Creator<OAuth2AuthzSession>(){

        public OAuth2AuthzSession createFromParcel(Parcel in) {
            return new OAuth2AuthzSession(in);
        }

        public OAuth2AuthzSession[] newArray(int size) {
            return new OAuth2AuthzSession[size];
        }
    };

    private OAuth2AuthzSession(Parcel in) {
        this.clientId = in.readString();
        this.accessToken = in.readString();
        this.authorizationCode = in.readString();
        this.refreshToken = in.readString();
        this.accountId = in.readString();
        this.expires_on = in.readLong();
    }

    public OAuth2AuthzSession() {
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public long getExpires_on() {
        return this.expires_on;
    }

    public void setExpires_on(long expires_on) {
        this.expires_on = expires_on;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2AuthzSession that = (OAuth2AuthzSession)o;
        if (this.expires_on != that.expires_on) {
            return false;
        }
        if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.authorizationCode != null ? !this.authorizationCode.equals(that.authorizationCode) : that.authorizationCode != null) {
            return false;
        }
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        return !(this.refreshToken != null ? !this.refreshToken.equals(that.refreshToken) : that.refreshToken != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        result = 31 * result + (this.authorizationCode != null ? this.authorizationCode.hashCode() : 0);
        result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
        result = 31 * result + (int)(this.expires_on ^ this.expires_on >>> 32);
        return result;
    }

    public String toString() {
        return "AuthzSession {cliendId=" + this.clientId + ", accessToken=" + this.accessToken + ", authorizationCode=" + this.authorizationCode + ", refreshToken=" + this.refreshToken + ", accountId=" + this.accountId + ", expires_on=" + this.expires_on + "}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.clientId);
        dest.writeString(this.accessToken);
        dest.writeString(this.authorizationCode);
        dest.writeString(this.refreshToken);
        dest.writeString(this.accountId);
        dest.writeLong(this.expires_on);
    }

    public boolean tokenIsNotExpired() {
        if (this.expires_on == 0L) {
            return true;
        }
        return this.expires_on > new Date().getTime();
    }
}

