/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.oauth2;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.core.Callback;

public class OAuth2FetchAccess {
    private final OAuth2AuthzService service;

    public OAuth2FetchAccess(OAuth2AuthzService service) {
        this.service = service;
    }

    public void fetchAccessCode(final String accountId, final OAuth2Properties config, final Callback<String> callback) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<Object, Void, Object>(){

                protected Object doInBackground(Object ... params) {
                    try {
                        return OAuth2FetchAccess.this.service.fetchAccessToken((String)params[0], (OAuth2Properties)params[1]);
                    }
                    catch (OAuth2AuthorizationException ex) {
                        return ex;
                    }
                }

                protected void onPostExecute(Object result) {
                    if (result instanceof String || result == null) {
                        callback.onSuccess((Object)((String)result));
                    } else {
                        callback.onFailure((Exception)result);
                    }
                }
            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[]{accountId, config});
        } else {
            new Handler(Looper.myLooper()).post(new Runnable(){

                @Override
                public void run() {
                    try {
                        String code = OAuth2FetchAccess.this.service.fetchAccessToken(accountId, config);
                        callback.onSuccess((Object)code);
                    }
                    catch (OAuth2AuthorizationException ex) {
                        callback.onFailure((Exception)ex);
                    }
                }
            });
        }
    }
}

