/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.oauth2;

import android.net.Uri;
import android.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.pipe.util.UrlUtils;

public final class OAuth2Utils {
    private OAuth2Utils() {
    }

    public static URL buildAuthzURL(OAuth2Properties config, String state) throws UnsupportedEncodingException, MalformedURLException {
        URL authzEndpoint = UrlUtils.appendToBaseURL((URL)config.getBaseURL(), (String)config.getAuthzEndpoint());
        Uri redirectURL = Uri.parse((String)config.getRedirectURL());
        ArrayList<String> scopes = new ArrayList<String>(config.getScopes());
        String clientId = config.getClientId();
        String query = "?scope=%s&redirect_uri=%s&client_id=%s&state=%s&response_type=code";
        query = String.format(query, OAuth2Utils.formatScopes(scopes), URLEncoder.encode(redirectURL.toString(), "UTF-8"), clientId, state);
        if (config.getAdditionalAuthorizationParams() != null && config.getAdditionalAuthorizationParams().size() > 0) {
            for (Pair<String, String> param : config.getAdditionalAuthorizationParams()) {
                query = query + String.format("&%s=%s", URLEncoder.encode((String)param.first, "UTF-8"), URLEncoder.encode((String)param.second, "UTF-8"));
            }
        }
        return new URL(authzEndpoint.toString() + query);
    }

    public static String formatScopes(ArrayList<String> scopes) throws UnsupportedEncodingException {
        StringBuilder scopeValue = new StringBuilder();
        String append = "";
        for (String scope : scopes) {
            scopeValue.append(append);
            scopeValue.append(URLEncoder.encode(scope, "UTF-8"));
            append = "+";
        }
        return scopeValue.toString();
    }
}

