/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.oauth2.intent;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.IBinder;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzModule;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2FetchAccess;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Utils;
import org.jboss.aerogear.android.core.Callback;

public class OAuth2IntentAuthzModule
extends OAuth2AuthzModule {
    public OAuth2IntentAuthzModule(OAuth2Properties params) {
        super(params);
    }

    @Override
    public void requestAccess(final Activity activity, final Callback<String> callback) {
        final String state = UUID.randomUUID().toString();
        OAuth2AuthzService.AGAuthzServiceConnection connection = new OAuth2AuthzService.AGAuthzServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName className, IBinder iBinder) {
                super.onServiceConnected(className, iBinder);
                OAuth2IntentAuthzModule.this.doRequestAccess(state, activity, (Callback<String>)callback, this);
            }
        };
        activity.bindService(new Intent(activity.getApplicationContext(), OAuth2AuthzService.class), (ServiceConnection)connection, 1);
    }

    private void doRequestAccess(String state, Activity activity, Callback<String> callback, OAuth2AuthzService.AGAuthzServiceConnection instance) {
        block8: {
            this.service = instance.getService();
            if (this.isNullOrEmpty(this.accountId)) {
                throw new IllegalArgumentException("need to have accountId set");
            }
            if (!this.service.hasAccount(this.accountId)) {
                try {
                    if (activity.getIntent() == null || activity.getIntent().getData() == null) {
                        URL authzURL = OAuth2Utils.buildAuthzURL(this.config, state);
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setData(Uri.parse((String)authzURL.toString()));
                        activity.unbindService((ServiceConnection)instance);
                        activity.startActivity(intent);
                        break block8;
                    }
                    Uri data = activity.getIntent().getData();
                    String code = data.getQueryParameter("code");
                    if (code == null) {
                        callback.onFailure((Exception)new IllegalStateException("nocode"));
                        return;
                    }
                    OAuth2AuthzSession session = new OAuth2AuthzSession();
                    session.setAuthorizationCode(code);
                    session.setAccountId(this.accountId);
                    session.setClientId(this.clientId);
                    this.service.addAccount(session);
                    OAuth2FetchAccess fetcher = new OAuth2FetchAccess(this.service);
                    fetcher.fetchAccessCode(this.accountId, this.config, callback);
                    this.account = this.service.getAccount(this.accountId);
                }
                catch (UnsupportedEncodingException ex) {
                    Log.e((String)this.TAG, (String)ex.getMessage(), (Throwable)ex);
                    callback.onFailure((Exception)ex);
                }
                catch (MalformedURLException ex) {
                    Log.e((String)this.TAG, (String)ex.getMessage(), (Throwable)ex);
                    callback.onFailure((Exception)ex);
                }
            } else {
                OAuth2FetchAccess fetcher = new OAuth2FetchAccess(this.service);
                fetcher.fetchAccessCode(this.accountId, this.config, callback);
                this.account = this.service.getAccount(this.accountId);
            }
        }
    }
}

