/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization;

import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.authorization.AuthorizationConfiguration;
import org.jboss.aerogear.android.authorization.AuthzModule;
import org.jboss.aerogear.android.authorization.OnAuthorizationCreatedListener;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationConfiguration;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthroizationConfigurationProvider;
import org.jboss.aerogear.android.core.ConfigurationProvider;

public final class AuthorizationManager {
    private static Map<String, AuthzModule> modules = new HashMap<String, AuthzModule>();
    private static Map<Class<? extends AuthorizationConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnAuthorizationCreatedListener onAuthorizationCreatedListener = new OnAuthorizationCreatedListener(){

        @Override
        public void onAuthorizationCreated(AuthorizationConfiguration<?> configuration, AuthzModule module) {
            modules.put(configuration.getName(), module);
        }
    };

    private AuthorizationManager() {
    }

    public static <CFG extends AuthorizationConfiguration<CFG>> void registerConfigurationProvider(Class<CFG> configurationClass, ConfigurationProvider<CFG> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends AuthorizationConfiguration<CFG>> CFG config(String name, Class<CFG> authorizationConfigurationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(authorizationConfigurationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((AuthorizationConfiguration)provider.newConfiguration()).setName(name).addOnAuthorizationCreatedListener(onAuthorizationCreatedListener);
    }

    public static AuthzModule getModule(String name) {
        return modules.get(name);
    }

    static {
        OAuth2AuthroizationConfigurationProvider oauth2ConfigurationProvider = new OAuth2AuthroizationConfigurationProvider();
        AuthorizationManager.registerConfigurationProvider(OAuth2AuthorizationConfiguration.class, oauth2ConfigurationProvider);
    }
}

